#include "mbed.h"
#include "wdt.h"

// Sample program using the Watchdog
// ---------------------------------
//    * Three threads co-operate to flash two LEDs
//    * A simple way to inject a fault, by pressing a button 
//    * The watchdog is configured with a 1sec timeout

#define ON 1
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalOut led_blue(LED_BLUE, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
DigitalOut led2(PTC13, OFF);
AnalogIn ain(A0) ;          // Analog input
EventQueue queue;  // creates an event queue, to call read ADC

Serial pc(USBTX, USBRX); // tx, rx, useful for debugging

// This ticker is used to feed the watch dog
Ticker tick;

// Threads
Thread threadT ; // timer thread 
Thread threadLED1 ; // thread LED1
Thread threadLED2 ; // thread LED2

# define ON1 0x01   
# define ON2 0x02
# define OFF1 0x04   
# define OFF2 0x08
EventFlags signals;  // event flags for signalling


// ------------Fault Injection Button-------------
//  Wait while the button is down
//     Use this to simulate a STUCK fault
// -----------------------------------------------
void waitButton() {
    while (!button) ;  
}


    // Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals 
// -----------------------------------------------
void led1_thread() {  // method to run in thread
    int volts = 0;
    char vstring[] = "X.XX\r\n" ;
    int evt ;
    while (true) {
        evt = signals.wait_any(ON1 | OFF1); // wait for either signal
        if (evt & ON1) {
            led1 = ON ;
            ThisThread::sleep_for(1) ;
            // check if led is working
            volts = ain.read_u16();
            vToString(volts, vstring) ;
            if (volts > 100 && volts < 250) {
                pc.printf(vstring) ;
                while(true) {
                    led_blue = OFF;
                }
                wdt_kickA() ;
            } else {
                pc.printf(vstring) ;
                led_red = OFF;
            }
        }
        if (evt & OFF1) led1 = OFF ;

        // waitButton() ;  // POSSIBLE FAULT HERE
        

    }
}

// ---Thread for controlling LED 2----------------
//   Turn LED2 on/off in response to signals 
// -----------------------------------------------
void led2_thread() {  // method to run in thread
    int evt ;
    while (true) {
        evt = signals.wait_any(ON2 | OFF2); // wait for any signal
        if (evt & ON2) led2 = ON ;
        if (evt & OFF2) led2 = OFF ;
        // waitButton() ; // POSSIBLE FAULT HERE
         wdt_kickB() ;
    }
}

// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread() {  // method to run in thread
    while (true) {
        ThisThread::sleep_for(1000) ;
        signals.set(ON1 | ON2) ;
        ThisThread::sleep_for(1000) ;
        signals.set(OFF1 | OFF2) ;
         //waitButton() ; // POSSIBLE FAULT HERE
    }
}






// -----------MAIN-------------------------------
//    Configure watchdog. Start threads. 
//    Show start up with RED for 1sec
//    Remember the watchdog is running
//       - 1024ms to set it once
//       - then must feed it every 32ms  
// ----------------------------------------------

int main(void) {
    wdt_1sec() ; // initialise watchdog - 32ms timeout
    
    
    // start threads
    threadT.start(timer_thread) ; // start the timer thread 
    threadLED1.start(led1_thread) ; // start the LED1 control thread 
    threadLED2.start(led2_thread) ; // start the LED2 control thread 
    
    
    // main thread does nothing more
    while (true) {

        ThisThread::sleep_for(10000) ;
    }
}