#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
TSISensor tsi;

Thread redThread ; // thread for red LED
Thread greenThread ; // thread for green LED
Thread blueThread ; 

# define REDFLAG 0x01   
# define GREENFLAG 0x02

# define BLUEFLAG 0x04
# define EXFLAG 0x08

EventFlags signals;  // event flags for signalling; 2 used
 
void red_thread() {  // method to run in thread
enum redState{ON, OFF};
    redLED = true ; // off
    redState state = OFF ;
    while (true) {
        switch (state) {
            case OFF: 
                signals.wait_any(REDFLAG);
                redLED = false ; // turn on 
                state = ON ;
                break ;
            case ON: 
                signals.wait_any(REDFLAG);
                redLED = true; // turn off
                state = OFF ;
                break ;
        }
        //signals.clear(REDFLAG) ;
          // Signal are automatically cleared by wait_any but
          // the signal might have been set again while LED on 
    }
}

void green_thread() {  // method to run in thread
enum greenState{ON, OFF};
    greenLED = true ; // off
    greenState state = OFF ;
    while (true) {
        switch (state) {
            case OFF: 
                signals.wait_any(GREENFLAG);
                greenLED = false ; // turn on 
                state = ON ;
                break ;
            case ON: 
                signals.wait_any(GREENFLAG);
                greenLED = true; // turn off
                state = OFF ;
                break ;
        }

        //signals.clear(GREENFLAG) ;
          // Signal are automatically cleared by wait_any but
          // the signal might have been set again while LED on 
    }
}

void blue_thread() {  // method to run in thread
enum blueState{ON, OFF};
    blueLED = true ; // off
    blueState state = OFF ;
    while (true) {
        switch (state) {
            case OFF: 
                signals.wait_any(BLUEFLAG);
                blueLED = false ; // turn on 
                state = ON ;
                break ;
            case ON: 
                signals.wait_any(BLUEFLAG);
                blueLED = true; // turn off
                state = OFF ;
                break ;
        }
        //signals.clear(BLUEFLAG) ;
          // Signal are automatically cleared by wait_any but
          // the signal might have been set again while LED on 
    }
}


int main(void) {
    //redLED = true ; // turn off 
    //greenLED = true ; // turn off 
    //blueLED = true ; // turn off 
    redThread.start(red_thread) ; // start the red thread
    greenThread.start(green_thread) ; // start the green thread
    blueThread.start(blue_thread) ; // start the blue thread
  
    enum ledState{none, leftout, leftin, rightout, rightin};
    ledState pos = none;
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value                      
        switch (pos) {
            case none:
                if (d > 3 && d < 9) {
                    signals.set(REDFLAG);
                    pos = leftout;
                }
                if (d > 13 && d < 19) {
                    signals.set(GREENFLAG);
                    pos = leftin;
                }
                if (d > 23 && d < 29) {
                    signals.set(BLUEFLAG);
                    pos = rightin;
                }
                if (d > 33) {
                    signals.set(EXFLAG);
                    pos = rightout;
                }
                break ;
                
            case leftout:
                if (d < 3 || d > 9) {
                    pos = none;
                }
                break ;
                
            case leftin:
                if (d < 13 || d > 19) {
                    pos = none;
                }
                break ;
                
            case rightin:
                if (d < 23 || d > 29) {
                    pos = none;
                }
                break ;
                
            case rightout:
                if (d < 33) {
                    pos = none;
                }
                break ;                
        }
        
        pc.printf("%d", d) ;
        pc.putc(' ') ;
        ThisThread::sleep_for(500) ; // This polling rate is too slow - increase it
                    // The slower rate maks it easier to output on the terminal
    }
}