#include "mbed.h"
#include "MMA8451Q.h"

#define SAMPLE_FLAG1 (1UL << 0)
#define SAMPLE_FLAG2 (1UL << 9)

EventFlags event_flags;

void worker_thread_fun()
{
    printf("Waiting for any flag from 0x%08lx.\r\n", SAMPLE_FLAG1 | SAMPLE_FLAG2);
    uint32_t flags_read = 0;
    while (true) {
        flags_read = event_flags.wait_any(SAMPLE_FLAG1 | SAMPLE_FLAG2);
        printf("Got: 0x%08lx\r\n", flags_read);
    }
}

Timer t;

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    
    Thread worker_thread;
    worker_thread.start(mbed::callback(worker_thread_fun));


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    EventFlags event_flags;

    
        int counterFlat = 0;
        int counterOver = 0;
        int counterRight = 0;
        int counterLeft = 0;
        int counterUp = 0;
        int counterDown = 0;
        
    
    enum ledState { flat, right, left, down, up, over, intermediate };

    while (true) {
        float x, y, z;
        
//        wait(1.0);
  //      event_flags.set(SAMPLE_FLAG1);
  //      wait(0.5);
  //      event_flags.set(SAMPLE_FLAG2);

        float maxThreshold = 0.9;
        float minThreshold = -0.9;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        t.start();
        
        ledState state = flat;
        switch (state) {
            case flat:
                if ( z > maxThreshold && counterFlat == 0){
                            rled = 1.0f - abs(x);
                            gled = 1.0f - abs(y);
                            bled = 1.0f - abs(z);
                            pc.printf("The board is Flat \n");
                            counterFlat++;
                            
                            counterOver = 0;
                            counterRight = 0;
                            counterLeft = 0;
                            counterUp = 0;
                            counterDown = 0;
                            break;
                            }
                            state = over;
                           // 
                            
            case over:
                if ( z < minThreshold && counterOver == 0) {
                    rled = 1.0f - abs(x);
                    gled = 1.0f - abs(y);
                    bled = 1.0f - abs(z);
                    pc.printf("The board is Over \n");
                    counterOver++;
                    counterFlat = 0;
                    counterRight = 0;
                    counterLeft = 0;
                    counterUp = 0;
                    counterDown = 0;
                    break;
                }
                state = right;
            //
                            
            case right:
                if ( x > maxThreshold && counterRight == 0){
                            rled = 1.0f - abs(x);
                            gled = 1.0f - abs(y);
                            bled = 1.0f - abs(z);
                            pc.printf("The board is Up \n");
                            counterFlat = 0;
                            counterOver = 0;
                            counterRight++;
                            counterLeft = 0;
                            counterUp = 0;
                            counterDown = 0;
                            
                            break; 
                            }
                            state = left;
                           // 
                            
            case left:
                if ( x < minThreshold && counterLeft == 0){
                            rled = 1.0f - abs(x);
                            gled = 1.0f - abs(y);
                            bled = 1.0f - abs(z);
                            pc.printf("The board is Down \n");
                            
                            counterFlat = 0;
                            counterOver = 0;
                            counterRight = 0;
                            counterLeft++;
                            counterUp = 0;
                            counterDown = 0;
                            break;
                            }
                            state = up;
                            //
                            
            case up:
                if ( y > maxThreshold && counterUp == 0){
                            rled = 1.0f - abs(x);
                            gled = 1.0f - abs(y);
                            bled = 1.0f - abs(z);
                            pc.printf("The board is Left \n");
                            counterFlat = 0;
                            counterOver = 0;
                            counterRight = 0;
                            counterLeft = 0;
                            counterUp++;
                            counterDown = 0;
                            break;
                            }
                            state = down;
                           // 
                            
            case down:
                if ( y < minThreshold && counterDown == 0){
                            rled = 1.0f - abs(x);
                            gled = 1.0f - abs(y);
                            bled = 1.0f - abs(z);
                            pc.printf("The board is Right \n");
                            counterFlat = 0;
                            counterOver = 0;
                            counterRight = 0;
                            counterLeft = 0;
                            counterUp = 0;
                            counterDown++;
                            break;
                            }
                            state = intermediate;
                            //
            case intermediate:
                if ( z <= maxThreshold && z >= minThreshold && x <= maxThreshold && x >= minThreshold && y <= maxThreshold && y > minThreshold ){
               
                            rled = 1;
                            gled = 1;
                            bled = 1;
                            
                            counterFlat = 0;
                            counterOver = 0;
                            counterRight = 0;
                            counterLeft = 0;
                            counterUp = 0;
                            counterDown = 0;
                           // pc.printf("The board is in Intermediate state");

                           }
            
            }
            
            t.stop();
        

        ThisThread::sleep_for(300);  // wait(0.3);
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
        //printf("The time taken was %f seconds\n", t.read());
    }
}
