
// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5 
//   Revised to replace Ticker with event queue and thread     

#include "mbed.h"


AnalogIn ain(A0) ;          // Analog input
DigitalOut led1(D2);   // Red LED
DigitalOut led2(D3);   // Red LED
DigitalOut led3(D4);   // Green LED
DigitalOut led4(D5);   // Red LED
DigitalOut led5(D6);   // Green LED
EventQueue queue;  // creates an event queue, to call read ADC

volatile int pressEvent = 0 ;

//DigitalIn b1(PTD0, PullUp);
InterruptIn button(PTD0);  // Pin must be on ports A or D


// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){
    pressEvent = 1 ;  
}

// enum buttonPos { up, down, bounce }; // Button positions


Serial pc(USBTX, USBRX); // tx, rx, for debugging

// This thread runs the event queue
Thread eventThread ;

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Average using a low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 

void readA0() {
    //pollT.start(callback(polling));
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }
    
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}


// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {
    int extra = 50;
    led1 = 1 ; // turn off 
   
    int volts = 0 ;
     int threshold = 55 ;  // 55 * 6 = 330
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;
    
    // write a comment here
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge

    
    // Start the event queue
    eventThread.start(callback( &queue, &EventQueue::dispatch_forever));

    // call the readA0 function every 10ms 
    queue.call_every(10, readA0) ; 

    while (true) {
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            if (pressEvent) {
                pressEvent = 0 ;
                threshold = volts / 6 ;
            }
            mailbox.free(mess) ;  // free the message space
            if (volts < threshold) led1 = 0 ; else led1 = 1 ;
            if (volts < threshold * 2) led2 = 0 ; else led2 = 1 ;
            if (volts < threshold * 3) led3 = 0 ; else led3 = 1 ;
            if (volts < threshold * 4) led4 = 0 ; else led4 = 1 ;
            if (volts < threshold * 5) led5 = 0 ; else led5 = 1 ;
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            } 
                                                                  }
        }
    }
}
