

//#include "EthernetInterface.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h" // need for main thread sleep
#include "html.h" // need for html patch working with web server
#include "bloc_io.h"
#define RADIUS  0.2F // wheel size
#define NBPOLES 8 // magnetic pole number
#define DELTA_T 0.1F // speed measurement counting period
#define TickVitessePeriode 0.1
#define CirconferenceRoue 1.25664F

Bloc_IO MyPLD(p25,p26,p5,p6,p7,p8,p9,p10,p23,p24);// instantiate object needed to communicate with PLD
// analog input connected to mbed
// valid pmw mbed pin
Serial pc(USBTX, USBRX); // tx, rx
// Top_Hall Pin

/************ persistent file parameters section *****************/
LocalFileSystem local("local");               // Create the local filesystem under the name "local"


/********************* web server section **********************************/

var_field_t tab_balise[10];  //une balise est présente dans le squelette
int giCounter=0;// acces counting


/*********************** can bus section  ************/
// determine message ID used to send Gaz ref over can bus
#define _CAN_DEBUG // used to debug can bus activity
//#define USE_CAN_REF // uncomment to receive gaz ref over can_bus
CAN can_port (p30, p29); // initialisation du Bus CAN sur les broches 30 (rd) et 29(td) for lpc1768 + mbed shield
bool bCan_Active=false;


DigitalOut led1(LED1); //initialisation des Leds présentes sur le micro-controleur Mbed*/
DigitalOut led2(LED2);
DigitalOut led3(LED3); // blink when can message is sent
DigitalOut led4(LED4); // blink when can message is received

InterruptIn TopHallSku(p22);


float fVitesse = 0,fLimiteBridage=15;
int iCompteurHallVitesse = 0,iCompteurHallTotal=0,iCompteurHallPartiel=0;

AnalogIn AINPOIGNEE (p17);

Ticker Ticky;
Ticker TickVitesse;
Ticker Bridge;
Ticker TickPLD;

        FILE* fichier = NULL;
    
    int iMode=1;
    int iSortiePWM=0;
    int iConsignePWM=0;
    int iAllow=1;
    float fPoigneeMax=1,fPoigneeMin=0.5;
    
    
    int iBit6=0,iBit5=0,iBit4=0,iBit3=0,iBit2=0,iBit1=0,iBit0=0;

void ModeAutoPWM(void)
{
                if(iMode=1)
                {
                    iConsignePWM=(((AINPOIGNEE.read()-fPoigneeMin)/(fPoigneeMax-fPoigneeMin))*255);
                    if(iConsignePWM>254)
                    {   iConsignePWM=255;   }
                    else if (iConsignePWM<10)
                    {   iConsignePWM=0; } // FIN DE L'ACTUALISATION DE LA SORTIE PWM IDEALE
                    
                    if(iBit5==0) //frein , faire lecture ici
                    {   iSortiePWM=0;   }
                    else if(iConsignePWM>iSortiePWM && ((fVitesse/1000)<fLimiteBridage))
                    {   iSortiePWM++;   }
                    else if(iConsignePWM<iSortiePWM )
                    {   iSortiePWM--;   } // FIN DE L'ACTUALISATION DE LA SORTIE PWM PROGRESSIVE 
                }
                else if(iMode=0)
                {
                    iConsignePWM=0;
                    iSortiePWM=0;
                }
                
        MyPLD.write(iSortiePWM); // Ecriture sortie
}

void VitesseTopHall()
{
    fVitesse=((2*3.1415*0.2*iCompteurHallVitesse)/(TickVitessePeriode*8*6))*3600;
    iCompteurHallVitesse=0;
}

void Incrementation()
{
    iCompteurHallVitesse++;
    iCompteurHallTotal++;
    iCompteurHallPartiel++;
}
//************ local function prototypes *******************



void LecturePLD(void)
{
                int iLecture=MyPLD.read();
                if(iLecture>=64){iBit6=1;iLecture=iLecture-64;    }else{iBit6=0;}
                if(iLecture>=32){iBit5=1;iLecture=iLecture-32;    }else{iBit5=0;}
                if(iLecture>=16){iBit4=1;iLecture=iLecture-16;    }else{iBit4=0;}
                if(iLecture>=8) {iBit3=1;iLecture=iLecture-8;     }else{iBit3=0;}
                if(iLecture>=4) {iBit2=1;iLecture=iLecture-4;     }else{iBit2=0;}
                if(iLecture>=2) {iBit1=1;iLecture=iLecture-2;     }else{iBit1=0;}
                if(iLecture>=1) {iBit0=1;iLecture=iLecture-1;     }else{iBit0=0;}
}

void LireFichier()
{
    fichier = NULL;
    fichier = fopen("/local/GR2B.txt", "r");
    
    pc.printf("\n\r Ouverture du fichier pour lecture... ");
    if(fichier==NULL)
    {
        pc.printf("ERREUR !\n\r");
    }
    else
    {
        fscanf(fichier, "%g %g %g %d %d",&fPoigneeMin,&fPoigneeMax,&fLimiteBridage,&iCompteurHallTotal,&iCompteurHallPartiel);
        pc.printf(" SUCCES !\n\r");
        pc.printf("_____________________________________________________________________________\n\r");
        pc.printf("PoigneeMin\tPoigneeMax\tLimiteBridage\tCompteursTot\tCompteurPart\n\r");
        pc.printf("%g\t\t%g\t\t%g\t\t%d\t\t%d\n\r",fPoigneeMin,fPoigneeMax,fLimiteBridage,iCompteurHallTotal,iCompteurHallPartiel);
        pc.printf("_____________________________________________________________________________\n\r");
        fclose(fichier);
    }
}

void SauvegarderFichier()
{
        fclose(fichier);
        fichier = NULL;
        fichier = fopen("/local/GR2B.txt", "w");
        
        pc.printf("\n\r Ouverture du fichier pour ecriture... ");
        
        if(fichier==NULL)
        {
            printf("ERREUR !\n\r(valeurs seulement en mémoire vive)\n\r");
        }
        else
        {
            fprintf(fichier, "%g %g %g %d %d",fPoigneeMin,fPoigneeMax,fLimiteBridage,iCompteurHallTotal,iCompteurHallPartiel);
            pc.printf(" SUCCES !\n\r");
            pc.printf("_____________________________________________________________________________\n\r");
            pc.printf("PoigneeMin\tPoigneeMax\tLimiteBridage\tCompteursTot\tCompteurPart\n\r");
            pc.printf("%g\t\t%g\t\t%g\t\t%d\t\t%d\n\r",fPoigneeMin,fPoigneeMax,fLimiteBridage,iCompteurHallTotal,iCompteurHallPartiel);
            pc.printf("_____________________________________________________________________________\n\r");
            fclose(fichier);
        }
        
        fclose(fichier);
}



/**************** Read persistent data from text file located on local file system ****************/



/**************** write persitant  data to text file located on local file system ****************/


//************** calibation gaz function needed to record min_gaz and max_gaz value to persistent text file  ******************


// ************top hall counting interrupt needed for speed measurement


//********************** timer interrupt for speed measurement each 100ms  *************************






//********************* Timer Interrupt for gaz ref management each 10ms   ********************



/********* main cgi function used to patch data to the web server thread **********************************/
void CGI_Function(void) // cgi function that patch web data to empty web page
{
    char ma_chaine4[20]= {}; // needed to form html response

}


/*********************** CAN BUS SECTION  **********************/



void CAN_REC_THREAD(void const *args)
{
    int iCount,iError;

    while (bCan_Active) {
        Thread::wait(100);// wait 100ms
        // code todo

    }

}
//*************************** main function *****************************************
int main()
{
    TopHallSku.mode(PullUp);
    char cChoix=0;
    
    TickVitesse.attach(&VitesseTopHall,TickVitessePeriode);
    
    
    TickPLD.attach(&LecturePLD,0.1);
    
    TopHallSku.rise(&Incrementation);
    MyPLD.write(iConsignePWM);
    pc.printf("\n\r************************************");
    pc.printf("\n\r**                                **");
    pc.printf("\n\r**     PROGRAMME SCOOTER MBED     **");
    pc.printf("\n\r**                                **");
    pc.printf("\n\r************************************\n\r");
    
    LireFichier();
    


//***************************************** web section ********************************************/
//Init_Web_Server(&CGI_Function); // create and initialize tcp server socket and pass function pointer to local CGI function
//Thread WebThread(Web_Server_Thread);// create and launch web server thread
    /********* main cgi function used to patch data to the web server thread **********************************/

//******************************************* end web section  ************************************* /

    

//********************* can bus section initialisation *******************************************
//bCan_Active=true;// needed to lauchn CAN thread
//Thread CanThread(CAN_REC_THREAD);// create and launch can receiver  thread
//********************* end can bus section *****************************************************


    while(cChoix!='q' and cChoix!='Q')
    {
        if(iMode==1)
        {
            pc.printf(" \n\r\n\r\t*** MODE AUTOMATIQUE ***\n\r");
                iAllow=1;
                Ticky.attach(&ModeAutoPWM,0.05);
        }
        else
        {
            pc.printf(" \n\r\n\r\t*** MODE MANUEL ***\n\r");
                    iAllow=0;
                    Ticky.detach();
                    MyPLD.write(iConsignePWM);
        }
        pc.printf(" \t Veuillez selectionner une action : \n\r");
        pc.printf(" a: Changer de mode \n\r");
        pc.printf(" b: Calibrer \n\r");
        pc.printf(" c: Afficher dernieres valeurs de calibration\n\r");
        if(iMode==0)    {   pc.printf(" d: Saisir une consigne pwm \n\r");  }
        pc.printf(" e: Afficher Vitesse\n\r");
        pc.printf(" f: Lire PLD\n\r");
        pc.printf(" g: Changer limite bridage\n\r");
        pc.printf(" h: Remettre a 0 le kilometrage partiel\n\r");
        pc.printf(" q: Quitter \n\r");

        /************* multithreading : main thread need to sleep in order to allow web response */
        while (pc.readable()==0) { // determine if char availabler
            Thread::wait(10);   // wait 10 until char available on serial input
        }
        /************* end of main thread sleep  ****************/


        pc.scanf("%c",&cChoix);
        printf("\n\r");
        switch (cChoix)
        {
            case 'a':
                iMode=!iMode;
                Ticky.detach();
                iConsignePWM=0;
                MyPLD.write(iConsignePWM); 
                break;
            case 'b':
                iConsignePWM=0;
                MyPLD.write(iConsignePWM); 
                Ticky.detach();
                
                pc.printf("\n\r MODE DE CALIBRATION ! \n\r");
                pc.printf("MAINTENEZ LA POIGNEE AU MAX PENDANT 3 SECONDES : \n\r");
                pc.printf(" 1.. "); wait(1);pc.printf(" 2.. ");wait(1);pc.printf(" 3.. ");wait(1);
                fPoigneeMax=AINPOIGNEE.read()*100;fPoigneeMax=(int)fPoigneeMax;fPoigneeMax=fPoigneeMax/100;pc.printf("\t %g \n\r",fPoigneeMax);
                pc.printf("MAINTENEZ LA POIGNEE AU MIN PENDANT 3 SECONDES : \n\r");
                pc.printf(" 1.. "); wait(1);pc.printf(" 2.. ");wait(1);pc.printf(" 3.. ");wait(1);
                fPoigneeMin=AINPOIGNEE.read()*100;fPoigneeMin=(int)fPoigneeMin;fPoigneeMin=fPoigneeMin/100;pc.printf("\t %g \n\r",fPoigneeMin);
                pc.printf("ECRITURE EN MEMOIRE ... \n\r");
                //ecriture du fichier
                SauvegarderFichier();
                Ticky.attach(&ModeAutoPWM,0.01);
                //fin de l'ecriture du fichier
                pc.printf("FIN DU MODE DE CALIBRATION ! \n\r");
                break;
            case 'c':
                pc.printf("\n\r\t Valeurs de calibration : \t MIN=%.2f \tMAX=%.2f \n\r",fPoigneeMin,fPoigneeMax);
                break;
            case 'd':
                if(iMode==0)
                {
                    iAllow=0;
                    Ticky.detach();
                    iConsignePWM=0;
                    pc.printf("\n\r\t MODE DE SAISIE DE CONSIGNE PWM\n\r");
                    pc.printf("ENTREE DE LA CONSIGNE ...\n\r(valeur entiere entre 0 et 255)\n\r");
                    pc.scanf("%d",&iConsignePWM);
                    MyPLD.write(iConsignePWM);
                    pc.printf("CONSIGNE ENREGISTREE ! : %d\n\r",iConsignePWM);
                    pc.printf("FIN DU MODE SAISIE !\n\r\n\r");
                    Ticky.detach();
                }
                
                break;
            case 'e':
            
                pc.printf("\n\r\n\r Vitesse = %.2F km/h",fVitesse/1000);
                pc.printf("\n\r Vitesse = %.2F m/s\n\r",fVitesse/3600);
                pc.printf("\n\r Bridage : %g km/h\n\r",fLimiteBridage);
                pc.printf("\n\r Kilometres parcourus (total): %.3f km\n\r",(((iCompteurHallTotal/48)*CirconferenceRoue)/1000));
                pc.printf("\n\r Kilometres parcourus (partiel): %.3f km\n\r",(((iCompteurHallPartiel/48)*CirconferenceRoue)/1000));
                
                break;
            case 'f':
                LecturePLD();
                //pc.printf("\n\r\t Valeur de PLD en int : %d \n\r",MyPLD.read());
                
                if(iBit3==1){pc.printf("\n\r PAS DE SURCHARGE COURRANT ");}     else{pc.printf("\n\r SURCHARGE COURRANT ");}
                if(iBit5==1){pc.printf("\n\r Frein INACTIF ");}                 else{pc.printf("\n\r Frein ACTIF ");}
                if(iBit4==1){pc.printf("\n\r PAS D'ERREUR CONVERTISSEUR ");}    else{pc.printf("\n\r ERREUR CONVERTISSEUR ");}
                if(iBit3==1){pc.printf("\n\r Direction AVANT ");}               else{pc.printf("\n\r Direction ARRIERE ");}
                /*
                pc.printf("\n\r BIT 2 : %d HALL C               ",iBit2);
                pc.printf("\n\r BIT 1 : %d HALL B               ",iBit1);
                pc.printf("\n\r BIT 0 : %d HALL A               ",iBit0);
                */
                pc.printf("\n\r SECTEUR HALL : %d\n\r",iBit0*1+iBit1*2+iBit2*4);
                break;
            case 'g':
                pc.printf("\n\r Veuillez entrer une nouvelle valeur de limite bridage : \n\r");
                scanf("%g",&fLimiteBridage);
               
                SauvegarderFichier();
                Ticky.attach(&ModeAutoPWM,0.01);
                //fin de l'ecriture du fichier
                
                break;
            case 'h':
                printf("\n\rRemise a 0 ... ");iCompteurHallPartiel=0;printf("Fait !\n\r");
                break;
            case 'q':
                iConsignePWM=0;
                MyPLD.write(iConsignePWM); 
                Ticky.detach();
                SauvegarderFichier();
                
                break;
        }
    } // end while

    //************** thread deinit *********************
    //DeInit_Web_Server();
    //bCan_Active=false;
    //CanThread=false;// close can received thread
    pc.printf("\n\r=== FIN DU PROGRAMME === \n\r");
} // end main
