/*
* WiiClassicControllerReader. A program allowing the output of one or two
* Wii Classic Controllers to be read via I2C and decoded for use, using the mbed 
* microcontroller and its associated libraries.
*
* Written by Alfredo Guerrero <alfredog83@gmail.com> for the mbedGC open-source 
* game console <http://www.mbedgc.com>. Based on the original code for
* the WiiNunchuckReader written by Petras Saduikis <petras@petras.co.uk>.
*
* This file is part of WiiClassicControllerReader.
*
* WiiClassicControllerReader is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* WiiClassicControllerReader is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You can find a copy of the GNU General Public License at <http://www.gnu.org/licenses/>.
*/

#include "I2CConfig.h"
#include "WiiClassicControllerReader.h"

#define LOOP_DELAY    1    // seconds

// global declarations
Serial serial(USBTX, USBRX);

void ReadAndReport(WiiClassicControllerReader* const ctrlr, const char* const portname)
{
    int bufSize = 0;
    char* bufPtr = NULL;
    bool debug = true;

    ctrlr->RequestRead();
    serial.printf("%s: ", portname);
        
    if (debug)
    {
        bufSize = ctrlr->getBufferSize();
        bufPtr = ctrlr->getReadBuf();
        if (bufPtr != NULL)
        {
            for (int i = 0; i < bufSize; i++)
            {
                serial.printf("%x ", bufPtr[i]);
            }
            serial.printf("\r\n");
        }
    }
    serial.printf("\r\nA\tB\tX\tY\tZL\tZR\tDU\tDD\tDL\tDR\tH\r\n");    
    serial.printf("%d\t", ctrlr->getButtonA());
    serial.printf("%d\t", ctrlr->getButtonB());
    serial.printf("%d\t", ctrlr->getButtonX());
    serial.printf("%d\t", ctrlr->getButtonY());
    serial.printf("%d\t", ctrlr->getButtonZL());
    serial.printf("%d\t", ctrlr->getButtonZR());
    serial.printf("%d\t", ctrlr->getButtonDU());
    serial.printf("%d\t", ctrlr->getButtonDD());
    serial.printf("%d\t", ctrlr->getButtonDL());
    serial.printf("%d\t", ctrlr->getButtonDR());
    serial.printf("%d\t", ctrlr->getButtonHOME());
    serial.printf("\r\nSEL\tSTART\tLT\tLC\tRT\tRC\tLX\tLY\tRX\tRY\r\n");
    serial.printf("%d\t", ctrlr->getButtonSELECT());
    serial.printf("%d\t", ctrlr->getButtonSTART());
    serial.printf("%d\t", ctrlr->getButtonLT());
    serial.printf("%d\t", ctrlr->getButtonLC());
    serial.printf("%d\t", ctrlr->getButtonRT());
    serial.printf("%d\t", ctrlr->getButtonRC());
    serial.printf("%d\t", ctrlr->getLJoyX());
    serial.printf("%d\t", ctrlr->getLJoyY());
    serial.printf("%d\t", ctrlr->getRJoyX());
    serial.printf("%d\t", ctrlr->getRJoyY());
    serial.printf("\r\n\n\n");
}

int main() 
{
    WiiClassicControllerReader ctrlrA(I2CPort_A::SDA, I2CPort_A::SCL);
//    WiiClassicControllerReader ctrlrB(I2CPort_B::SDA, I2CPort_B::SCL);
    
    while (true)
    {
        ReadAndReport(&ctrlrA, "PORT A");
//        ReadAndReport(&ctrlrB, "PORT B");
                
        wait(LOOP_DELAY);
    }
        
    return EXIT_SUCCESS;
}