#include "brushlessMotor.h"

brushlessMotor::brushlessMotor(PinName pin1, PinName pin2, PinName pin3): pwm1(pin1), pwm2(pin2), pwm3(pin3) { //constructor van brushlessControll, telkens we een brushlesscontroll object maken roept het deze functie aan]
    //pwm pins instellen  
    
    //TODO: finetunes: andere khz pwm?
    pwm1.period(1/20000.0);   // 20 kHz pwm frequency voor elke pwm
    pwm2.period(1/20000.0);   // 20 kHz pwm frequency voor elke pwm
    pwm3.period(1/20000.0);   // 20 kHz pwm frequency voor elke pwm

        
    sinArraySize = sizeof(pwmSin) / sizeof(int);   // hoe groot is de lengte van de sinus array?
    phaseShift = sinArraySize / 3 ;                // elke spoel staat op 120% van elkaar
        
    step[0] = 0;
    step[1] = step[0] + phaseShift;
    step[2] = step[1] + phaseShift; 
}

void brushlessMotor::brushlessControl(bool dir, int delay_time)
{        
    //TODO: finetunen? Mss ipv 0.0-1.0 van 0.0 - 0.75
    pwm1 = pwmSin[step[0]]/255.0;       // Pwm waarde voor de sinus waarde waar we zijn van 0-255 --> 0.0 - 1.0
    pwm2 = pwmSin[step[1]]/255.0;       // Pwm waarde voor de sinus waarde waar we zijn van 0-255 --> 0.0 - 1.0
    pwm3 = pwmSin[step[2]]/255.0;       // Pwm waarde voor de sinus waarde waar we zijn van 0-255 --> 0.0 - 1.0

    for(int k=0; k<3; k++) //alle 3 de spoelen afgaan
    {     
        (dir == 1)? (step[k]++):(step[k]--);  // links of rechts? --> step naar voor of step naar achter
        
        /* begin of einde van de sinus array --> reset naar voor of achter */
        if(step[k] == sinArraySize - 1)   step[k] = 0; 
        if(step[k] < 0)                   step[k] = sinArraySize - 1;
    } 
    
    wait_us(delay_time);  //wacht zo lang --> hoe langer wachten hoe lager de snelheid
}