/* 06_spi_max7219_led8x8
 *
 * Simple demo to drive a 8x8-as LED matrix by a MAX7219 LED driver IC
 * After initialisation two characters (H and W) are displayed alternatively.
 * The MAX7219 IC is driven by hardware SPI: SPI0 module at PTD1, PTD2, PTD3.
 */
 
#include "mbed.h"
#include "MMA8451Q.h"

PinName const SDA = PTE25;
PinName const SCL = PTE24;
 
SPI spi(PTD2, PTD3, PTD1);          // Arduino compatible MOSI, MISO, SCLK
DigitalOut cs(PTD0);                // Chip select

#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
const unsigned char led1[]= {
    0xFF,0xB4,0x15,0xD1,0x85,0xB5,0x95,0xFF
};  //H
const unsigned char led2[]= {
    0x1F,0x60,0x80,0x40,0x40,0x80,0x60,0x1F
};  //W
 
/// Send two bytes to SPI bus
void SPI_Write2(unsigned char MSB, unsigned char LSB)
{
    cs = 0;                         // Set CS Low
    spi.write(MSB);                 // Send two bytes
    spi.write(LSB);
    cs = 1;                         // Set CS High
}

void direction(float x, float y){
    if(x > 0.5){
        printf("Left \n");
    }else if(x < -0.5){
        printf("Right \n");
    }else if(y > 0.5){
        printf("Up \n");
    }else if(y < -0.5){
        printf("Down \n");
    }else{
        printf("Neutral Position \n");    
      }
}
 
/// MAX7219 initialisation
void Init_MAX7219(void)
{
    SPI_Write2(0x09, 0x00);         // Decoding off
    SPI_Write2(0x0A, 0x08);         // Brightness to intermediate
    SPI_Write2(0x0B, 0x07);         // Scan limit = 7
    SPI_Write2(0x0C, 0x01);         // Normal operation mode
    SPI_Write2(0x0F, 0x0F);         // Enable display test
    wait_ms(500);                   // 500 ms delay
    SPI_Write2(0x01, 0x00);         // Clear row 0.
    SPI_Write2(0x02, 0x00);         // Clear row 1.
    SPI_Write2(0x03, 0x00);         // Clear row 2.
    SPI_Write2(0x04, 0x00);         // Clear row 3.
    SPI_Write2(0x05, 0x00);         // Clear row 4.
    SPI_Write2(0x06, 0x00);         // Clear row 5.
    SPI_Write2(0x07, 0x00);         // Clear row 6.
    SPI_Write2(0x08, 0x00);         // Clear row 7.
    SPI_Write2(0x0F, 0x00);         // Disable display test
    wait_ms(500);                   // 500 ms delay
}
 
int main()
{
    
    cs = 1;                         // CS initially High
    spi.format(8,0);                // 8-bit format, mode 0,0
    spi.frequency(1000000);         // SCLK = 1 MHz
    Init_MAX7219();                 // Initialize the LED controller
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    unsigned char row = 0x03;
    
            unsigned char position[] = {
            0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00
            };
    
     for(int i=1; i<9; i++)      // Write first character (8 rows)
            SPI_Write2(i,led1[i-1]);
    while (1) {

        float x, y;
        x = acc.getAccX();
        y = acc.getAccY();
        
    if(x > 0.5){
        printf("Left \n");
        position[1] = position[1]*2;
    }else if(x < -0.5){
        printf("Right \n");
        position[1] = position[1]/2;
    }else if(y > 0.5){
        printf("Up \n");
        position[0] = position[0]-1;
        row--;
    }else if(y < -0.5){
        printf("Down \n");
        position[0] = position[0]+1;
        row++;
        }


       
        wait(1);                    // 1 sec delay
        SPI_Write2(position[0], position[1]);
         for(int i=1; i<9; i++){      // Write first character (8 rows)
                if(i != row){
         SPI_Write2(i,led1[i-1]);
         }
        }
    }
    
    
}