#include "mbed.h"
#include "MMA8451Q.h"
#include "TSISensor.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
Timer t;
TSISensor tsi;

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    float led;

    while (true) {
        float x0, y0, z0, x1, y1, z1;
        x0 = abs(acc.getAccX());
        y0 = abs(acc.getAccY());
        z0 = abs(acc.getAccZ());
        wait(0.1);
        x1 = abs(acc.getAccX());
        y1 = abs(acc.getAccY());
        z1 = abs(acc.getAccZ());
        led = 1.0 - tsi.readPercentage();
        if(x1 - x0 > 0.6 || y1 - y0 > 0.6 || z1 - z0 > 0.6 ){
            bled = 1.0f;
            rled = 1.0f;
            wait(0.1);
        }
        
        bled = led;
        rled = led;
        gled = led;    
        //rled = 1.0f - x0;
        //gled = 1.0f - y0;
        //bled = 1.0f - z0;
        wait(0.1f);
        //printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
    }
}
