#include "mbed.h"
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Serial pc(USBTX,USBRX);

Thread *LED_THREAD_POINTER;

uint32_t UART_0_RBR;

void UART0_ISR(){
    UART_0_RBR = LPC_UART0->RBR;            // Clear the RBR flag to make sure the interrupt doesn't loop
    led3=!led3;
    (*LED_THREAD_POINTER).signal_set(0x1);  // Dereference the LED_THREAD_POINTER then set the signal  0x1 flag of the thread it points to
}

void led3blinker(void const *argument){
    while(true){
        Thread::signal_wait(0x1);
        led2=!led2;
        //Thread::wait(233);
    }
}

int main() {
    Thread led3blinkerthread(led3blinker);
    pc.attach(&UART0_ISR);
    LED_THREAD_POINTER = &led3blinkerthread;    // Set the globally-accessible thread pointer
    
    while(true){
        led1=!led1;
        Thread::wait(1000);
        led3blinkerthread.signal_set(0x1);
    }
}
