// Pin function definitions for BURT MKII DAQ Main Board r1.0
#ifndef BURTDAQ_H
#define BURTDAQ_H

// XBee serial port
#define XBEETX p28
#define XBEERX p27

// LCD serial port
#define LCDTX p9
#define LCDRX p10

// SPI A
#define SPIA_MOSI p5
#define SPIA_MISO p6
#define SPIA_CLK p7

#define SPIA_P1_CS p8       // P0.6
#define SPIA_P2_CS p14      // P0.16
#define SPIA_P3_CS p30      // P0.4
#define SPIA_P4_CS p29      // P0.5

#define SPIA_CS_PORT_MASK 0x10070
#define SPIA_P1_CS_PORT_MASK 0x40
#define SPIA_P2_CS_PORT_MASK 0x10000
#define SPIA_P3_CS_PORT_MASK 0x10
#define SPIA_P4_CS_PORT_MASK 0x20

// SPI B
#define SPIB_MOSI p11
#define SPIB_MISO p12
#define SPIB_CLK p13

#define SPIB_P1_CS p15
#define SPIB_P2_CS p16
#define SPIB_P3_CS p17
#define SPIB_P4_CS p19

// H-Bridge Outputs
#define MOTOR1 p25
#define MOTOR2 p24
#define MOTOR3 p22          // NOTE: Motor3 and Motor4 are mixed up in schematic, so the pins are out of order
#define MOTOR4 p23

// Filter Clock Output
#define FILTCLK p26

#endif