#include "mbed.h"
#include "m3pi.h"
#include "x_nucleo_53l0a1.h"
#include <stdio.h>

/* This VL53L0X Expansion board test application performs a range measurement in polling mode
   on the onboard embedded top sensor. */

#define VL53L0_I2C_SDA   D14 
#define VL53L0_I2C_SCL   D15 

static X_NUCLEO_53L0A1 *board=NULL;


//VIN -- VOUT
//GND -- GND
//SDA -- p9
//SCA -- p10

m3pi m3pi;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

int main() {
    //LIDAR setup
    int status;
    uint32_t distance;
    DevI2C *device_i2c =new DevI2C(p28, p27);         
    /* creates the 53L0A1 expansion board singleton obj */
    board = X_NUCLEO_53L0A1::Instance(device_i2c,p21,p21,p21);
    /* init the 53L0A1 expansion board with default values */
    status=board->InitBoard();
    
    if(status) { led1 = 1; return 0; }
    
    m3pi.locate(0,1);
    m3pi.printf("YO");
    
    while(1) {
        status = board->sensor_centre->GetDistance(&distance);
        if (status == VL53L0X_ERROR_NONE) {
            m3pi.locate(0,1);
            m3pi.printf("%u", distance);
            printf("%u\r\n", distance);
            if (distance > 50) {
                m3pi.forward(.1);
                led2 = 1;
            } else {
                m3pi.stop();
                led2 = 0;
            }
        }   
    }   
}