#include "mbed.h"
#include "m3pi.h"

m3pi m3pi;
DigitalOut led(LED1);
DigitalOut pong(p20);
Serial bt(p13, p14); //TX, RX

int main()
{
    m3pi.locate(0,1);
    m3pi.printf("YO");

    bt.baud(9600); //make sure the baud rate is 9600
    while (!bt.readable()) { } //wait until the bt is ready

    while(1) {
        led = !led;
        if (bt.getc() == '!') {
            if (bt.getc() == 'O') {
                if (bt.getc()=='F') {
                    m3pi.forward(.25);
                }
                if (bt.getc()=='B') {
                    m3pi.backward(.25);
                }
                if (bt.getc()=='L') {
                    m3pi.left(.25);
                }
                if (bt.getc()=='R') {
                    m3pi.right(.25);
                }
                if (bt.getc()=='S') {
                    m3pi.stop();
                }
                if (bt.getc()=='X') {
                    pong = 1;
                    wait(.001);
                    pong = 0;
                }
            }
        }
        while (bt.readable()) char temp = bt.getc(); //flush buffer
    }
}