#include <stdio.h>
#include "mbed.h"
Serial pc(USBTX, USBRX);
AnalogIn analogValue(A2);
DigitalIn userButton(USER_BUTTON);
DigitalOut led(LED1);

// Calculate the corresponding acquisition measure for a given value in mV
#define MV(x) ((0xFFF*x)/3300)

int main( void) {
    led = 0;
    pc.baud(9600);
    int count = 0;
    bool enFlag = true;
   while (1) {

        count++;
        if (userButton == 0) {
            enFlag = (enFlag == true) ? false : true;
            //pc.close();
        }
        if (enFlag) {
            unsigned short meas = (analogValue.read_u16());
            //float fl = analogValue.read() * 3300;
            //float final = (float) 3300* (float) meas / 65535 ; // normal 0.0008  or 3.3v-3300mV  0,8058608058608059 3300/4095
            pc.printf("%d; 16bit %hu val in mV: %d  \n", count,
                    meas, ((meas * 3300) / 0xFFFF)); //, (int) fl);

        }

        led = !led;

        wait(1.5f);
    }
return 0;
}
