/**
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: ZiWei Liu ,Alex
Username: el19z2l
Student ID Number: 201377806
Date: 2020.5.20
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "DodgeEngine.h"
#include "Character.h"
#include "Block.h"

#define x1up 80
#define y1up 1
#define x1down 80
#define y1down 15
#define x2up 80
#define y2up 35
#define x2down 80
#define y2down 46
#define manx 15
#define many 1

//objects
Gamepad pad;
N5110 lcd;
DodgeEngine dodge;
Character character;
Block block;

//prototypes
void init();
void welcome();
void refreshing();

int main()
{
    int fps=6;
    
    //initialize
    init(); 
    welcome();
    
    
    pad.leds_off();
    wait(1.0f/fps);
    
    //initate
    dodge.init(x1up, y1up, x1down, y1down, x2up, y2up,x2down,y2down, manx, many);
    while (1) {
        refreshing();
        wait(1.0f/fps);
    }
}


void init(){
  
  lcd.init();
  pad.init();   
  
}

void welcome(){
  //the start menu
  while(pad.A_pressed()==false){
  lcd.printString("   Dodging!!    " ,0,2);
  lcd.printString("    Press A     ",0,4);  
  lcd.refresh();
  }
  
  //the instruction menu
  lcd.clear();
  lcd.printString(" Instructions  ",0,0);
  lcd.printString("Dodge the walls ",0,1);
  lcd.printString("Hold A to move ",0,2);
  lcd.printString("   4 levels!    ",0,3);
  lcd.printString("  Good luck!   ",0,4);
  lcd.printString("Press    start",0,5);
  lcd.refresh();
  
  while(pad.start_pressed()==false){
      pad.led(1,1);
      pad.led(3,1);
      pad.led(4,1);
      pad.led(6,1);
  }
}

void refreshing(){
    
    lcd.clear();
    dodge.dodgeupdate(lcd,pad,x1up, y1up, x1down, y1down, x2up, y2up,x2down,y2down,manx, many);
    dodge.charactermove(lcd,pad);
    dodge.blockmove(lcd);
    lcd.refresh();
    
}