#ifndef DODGEENGINE_H
#define DODGEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Character.h"
#include "Block.h"

/** DodgeEngine class
 * @the engine of the whole game
 * @author ZiWei Liu Alex
 * @date May,2020
 */


class DodgeEngine{
    
    public:
    /**Constructor*/
    DodgeEngine();
    /**Destructor*/ 
    ~DodgeEngine();
    
    /** control the movement of character and the boundry of the character
     * @param lcd and gamepad
     */
    void charactermove(N5110 &lcd,Gamepad &pad);
    
    /** control the movement of blockmove 
     * @param lcd
     */
    void blockmove(N5110 &lcd);
    
    /** update the wall's movement and the score
     *@param lcd, gamepad and the coordinates of walls, character
     */
    void dodgeupdate(N5110 &lcd,Gamepad &pad,int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many);
    
    /** initate the character and wall
     * @param the coordinates of walls, character
     */
    void init(int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many);
    
    /** check if the character has collide with the wall
     * @param lcd,gamepad and the coordinates of the character,walls
     */
    void check_crash(N5110 &lcd, Gamepad &pad,int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many);
    
    /** print the score on the top left corner
     * @param lcd, gamepad and the coordinates of the character, walls
     */
    void print_score(N5110 &lcd, Gamepad &pad,int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many);
    
    /** show the score when game is over(failed)
     * @param lcd
     */
    void show_score(N5110 &lcd);
    
    /** show the score when game is over(passed)
     * @param lcd
     */
    void pass_game(N5110 &lcd, Gamepad &pad);
    
    private:
    Character character;
    Block block;

    
};

#endif
