#include "DodgeEngine.h"


DodgeEngine::DodgeEngine(){}
DodgeEngine::~DodgeEngine(){}

void DodgeEngine::init(int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many){
    
    //initiate the block and character
    block.blockinit(x1up, y1up, x1down, y1down, x2up, y2up,x2down,y2down);
    character.charinit(manx, many);
}

void DodgeEngine::charactermove(N5110 &lcd,Gamepad &pad){
    
    //control the movement and check for boundry
    character.move_up(pad);
    character.move_down();
    character.boundry();
    character.draw(lcd);
    
}

void DodgeEngine::blockmove(N5110 &lcd){
    
    //control the movement of the block
    block.draw_block(lcd);
       
}

void DodgeEngine::dodgeupdate(N5110 &lcd, Gamepad &pad,int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many){
    
    
    //check if the character has collide with the walls first
    check_crash(lcd,pad,x1up, y1up, x1down, y1down, x2up, y2up,x2down,y2down,manx, many);
    show_score(lcd);
    
    int updatescore;
    updatescore = block.get_score();
    
    //check if the player has pass the game
    if(updatescore > 39){
        pass_game(lcd,pad);
    }
        
    //update levels by score
    if(updatescore > 9 && updatescore < 20){
        //int test1 = 1;
        block.blockupgrate2();
    }
    else if(updatescore > 19 &&updatescore <30){
        //int test1 = 2;
        block.blockupgrate3();
    }
    else if(updatescore > 29 &&updatescore <40){
        //int test1 = 3;
        block.blockupgrate4();
    }
    else{
        //int test1 =4;
        block.blockupgrate();
    }
    //printf("the level is at = %d\n",test1);
    
    block.y_update();
  
     
    
}

void DodgeEngine::check_crash(N5110 &lcd, Gamepad &pad,int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many){
    Vector2D characterposition = character.get_char_position();
    Vector2D upperlimit = block.getposition2();
    Vector2D lowerlimit = block.getposition3();
    
    //check if character has fall on the ground
    if(characterposition.y > 35){
      
        //audio and led feedback
        pad.tone(500.0,0.5);
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        print_score(lcd,pad,x1up, y1up, x1down, y1down, x2up, y2up,x2down,y2down,manx, many);
        
    }
    //check if character has crash on the wall
    if(upperlimit.x > 15 && upperlimit.x < 26){
        
        if(characterposition.y < upperlimit.y || characterposition.y + 11 > lowerlimit.y ){
            
            pad.leds_on();
            pad.tone(500.0,0.5);
            print_score(lcd,pad,x1up, y1up, x1down, y1down, x2up, y2up,x2down,y2down,manx, many);
        }
    }
    
    int check_crash_score;
    check_crash_score = block.get_score();
    
    //printf("score = %2d\n", check_crash_score)
    
    //check the score and update the level, each level has different coordinates
    //for adding the score becasue of the velocity different
    if(check_crash_score < 10){
        //int test2 = 1;
        if(upperlimit.x > 13 && upperlimit.x < 15){
            block.add_score();
        }
    }
    else if(check_crash_score >9 && check_crash_score < 20){
        //int test2 = 2;
        if(upperlimit.x > 12 && upperlimit.x < 15){
            block.add_score();
        }
    }
    else if(check_crash_score >19 && check_crash_score < 30){
        //int test2 = 3;
        if(upperlimit.x > 11 && upperlimit.x < 15){
            block.add_score();
        }
    }
    else{ 
        //int test2 = 4;
        if(upperlimit.x > 10 && upperlimit.x < 15){
            block.add_score();
        }
    
    }
    //printf("the level2 is at = %d\n",test2);
 }   
 
 void DodgeEngine::print_score(N5110 &lcd, Gamepad &pad,int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down, int manx, int many){
    
    
    int finalscore = block.get_score();
    lcd.clear();
    char score[14];
    while(pad.B_pressed() == false){
        sprintf(score, "%2d score!", finalscore);
        lcd.printString("Finally...",1,0);
        lcd.printString("You achieved",1,1);
        lcd.printString(score,1,2);
        lcd.printString("Try again?",1,3);
        lcd.printString("press B",1,4);
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
        lcd.refresh();
    }
    lcd.clear();
    init(x1up, y1up, x1down, y1down, x2up, y2up,x2down,y2down,manx, many);
    
}

//show the score on the top left corner on the lcd screen    
void DodgeEngine::show_score(N5110 &lcd){
    
    int showscore = block.get_score();
    char score2[10];
    sprintf(score2, "%2d", showscore);
    lcd.printString(score2,0,0);
    lcd.refresh();
    
}

void DodgeEngine::pass_game(N5110 &lcd, Gamepad &pad){
    
    lcd.clear();
    while(pad.B_pressed() == false){
        lcd.printString("Congratulation",1,1);
        lcd.printString("All level pass",1,2);
        lcd.printString("  Try Again?  ",1,4);
        lcd.printString("    Press B   ",1,5);
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
        lcd.refresh();
    }
}
    