#ifndef CHARACTER_H
#define CHARACTER_H

#include"mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Character class
 * @create the character and control the move of character
 * @author ZiWei Liu Alex
 * @date May,2020
 */

class Character{
    
    private:
    float charx;
    float chary;
    
    public:
    /**Constructor*/
    Character();
    /**Destructor*/
    ~Character();
    
    /** draw the character
     * @param the lcd screen
     */
    void draw(N5110 &lcd);
    
    /** control the character to move upwards
     * @param the gamepad
     */
    void move_up(Gamepad &pad);
    
    /** control the character to move dowwnwards because of gravity*/
    void move_down();
    
    /** set the upper and lower boundry of the character*/
    void boundry();
    
    /** initiate the character's position
     * @param the value of the x and y coordinates of the character
     */
    void charinit(int manx, int many);
    
    /** get the position of the character */
    Vector2D get_char_position();
    
    
};

#endif