#ifndef BLOCK_H
#define BLOCK_H

#include"mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Block class
 * @create the wall and control the update of the wall's position
 * @author ZiWei Liu Alex
 * @date May,2020
 */

class Block{
    
    private:
    
    int x1_up;
    int y1_up;
    int x1_down;
    int y1_down;
    int x2_up;
    int y2_up;
    int x2_down;
    int y2_down;
    int score;
 
    public:
    /**Constructor*/
    Block(); 
    /**Destructor*/ 
    ~Block();  
    
    /** initiate the wall position
     * @param 8 coordinates for the wall(two lines)
     */
    void blockinit(int x1up, int y1up, int x1down, int y1down, int x2up, int y2up, int x2down, int y2down);
    
    /** draw the block
     * @param the lcd screen
     */
    void draw_block(N5110 &lcd);
    
    /** the upgrate of x coordinates for score 1-10(level 1)*/
    void blockupgrate();
    /** the upgrate of x coordinates for score 11-20(level 2)*/
    void blockupgrate2();
    /** the upgrate of x coordinates for score 21-30(level 3)*/
    void blockupgrate3();
    /** the upgrate of x coordinates for score 31-40(level 4)*/
    void blockupgrate4();
    /** the upgrate of y coordinates*/
    void y_update();
    
    /** get the position of x1up and y1up
     * return the vector contains the postion of x1up and y1up
     */
    Vector2D getposition1();
    /** get the position of x1down and y1down
     * return the vector contains the postion of x1down and y1down
     */
    Vector2D getposition2();
    /** get the position of x2up and y2up
     * return the vector contains the postion of x2up and y2up
     */
    Vector2D getposition3();
    /** get the position of x2down and y2down
     * return the vector contains the postion of x2down and y2down
     */
    Vector2D getposition4();
    
    /** add score by 1*/
    void add_score();
    
    /** get the score
     * @return the current score
     */
    int get_score();
    

};

#endif