#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

#define V_SERVO_CENTER 1800
#define V_SERVO_MAX 2200
#define V_SERVO_MIN 800
#define H_SERVO_CENTER 1600
#define H_SERVO_MAX 2200
#define H_SERVO_MIN 800

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

DigitalOut fire(PTB23);
PwmOut v_servo(PTC2);
PwmOut h_servo(PTA2);

int main()
{
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
 
    Websocket ws(/*LINK TO YOUR WEBSOCKET SERVER GOES HERE*/);
    ws.connect();
    char recv[6]="fire";
    
    v_servo.period_us(20000);          // servo requires a 20ms period
    v_servo.pulsewidth_us(V_SERVO_CENTER);
    h_servo.period_us(20000);          // servo requires a 20ms period
    h_servo.pulsewidth_us(H_SERVO_CENTER);
    fire = 0;
    
    int v_pulse = V_SERVO_CENTER;
    int h_pulse = H_SERVO_CENTER;

    v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
    h_servo.pulsewidth_us(h_pulse); // servo position determined by a pulsewidth between 1-2ms
    int move_x=0;
    int move_y=0;
    wait(0.5);
    
    while(1){
        if(ws.read(recv)){
            if(strcmp(recv,"fire")==0){
                fire=1;
                while(1){
                    wait(0.02);
                    ws.read(recv);
                    if(strcmp(recv,"stop")==0){
                        fire=0;
                        break;
                    }
                }
            }
            else if(strcmp(recv,"left")==0){
                while(1){
                    move_x-=10;
                    h_pulse = H_SERVO_CENTER + move_x;
    
                    if (h_pulse <= H_SERVO_MIN) h_pulse = H_SERVO_MIN;
                    if (h_pulse >= H_SERVO_MAX) h_pulse = H_SERVO_MAX;
    
                    h_servo.pulsewidth_us(h_pulse); // servo position determined by a pulsewidth between 1-2ms
                    ws.read(recv);
                    if(strcmp(recv,"stop")==0){
                        break;
                    }
                    wait(0.02);
                }
            }
            else if(strcmp(recv,"right")==0){
                while(1){
                    move_x+=10;
                    h_pulse = H_SERVO_CENTER + move_x;
        
                    if (h_pulse <= H_SERVO_MIN) h_pulse = H_SERVO_MIN;
                    if (h_pulse >= H_SERVO_MAX) h_pulse = H_SERVO_MAX;
        
                    h_servo.pulsewidth_us(h_pulse); // servo position determined by a pulsewidth between 1-2ms
                    ws.read(recv);
                    if(strcmp(recv,"stop")==0){
                        break;
                    }
                    wait(0.02);
                }
            }
            else if(strcmp(recv,"up")==0){
                while(1){
                    move_y-=10;
                    v_pulse = V_SERVO_CENTER + move_y;
        
                    if (v_pulse <= V_SERVO_MIN) v_pulse = V_SERVO_MIN;
                    if (v_pulse >= V_SERVO_MAX) v_pulse = V_SERVO_MAX;
        
                    v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
                    ws.read(recv);
                    if(strcmp(recv,"stop")==0){
                        break;
                    }
                    wait(0.02);
                }
            }
            else if(strcmp(recv,"down")==0){
                while(1){
                    move_y+=10;
                    v_pulse = V_SERVO_CENTER + move_y;
        
                    if (v_pulse <= V_SERVO_MIN) v_pulse = V_SERVO_MIN;
                    if (v_pulse >= V_SERVO_MAX) v_pulse = V_SERVO_MAX;
        
                    v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
                    ws.read(recv);
                    if(strcmp(recv,"stop")==0){
                        break;
                    }
                    wait(0.02);
                }
            }
            else if(strcmp(recv,"lpuls")==0){
                move_x-=25;
                h_pulse = H_SERVO_CENTER + move_x;

                if (h_pulse <= H_SERVO_MIN) h_pulse = H_SERVO_MIN;
                if (h_pulse >= H_SERVO_MAX) h_pulse = H_SERVO_MAX;

                h_servo.pulsewidth_us(h_pulse); // servo position determined by a pulsewidth between 1-2ms
            }
            else if(strcmp(recv,"rpuls")==0){
                move_x+=25;
                h_pulse = H_SERVO_CENTER + move_x;
    
                if (h_pulse <= H_SERVO_MIN) h_pulse = H_SERVO_MIN;
                if (h_pulse >= H_SERVO_MAX) h_pulse = H_SERVO_MAX;
    
                h_servo.pulsewidth_us(h_pulse); // servo position determined by a pulsewidth between 1-2ms
            }
            else if(strcmp(recv,"upuls")==0){
                move_y-=25;
                v_pulse = V_SERVO_CENTER + move_y;
    
                if (v_pulse <= V_SERVO_MIN) v_pulse = V_SERVO_MIN;
                if (v_pulse >= V_SERVO_MAX) v_pulse = V_SERVO_MAX;
    
                v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
            }
            else if(strcmp(recv,"dpuls")==0){
                move_y+=25;
                v_pulse = V_SERVO_CENTER + move_y;
    
                if (v_pulse <= V_SERVO_MIN) v_pulse = V_SERVO_MIN;
                if (v_pulse >= V_SERVO_MAX) v_pulse = V_SERVO_MAX;
    
                v_servo.pulsewidth_us(v_pulse); // servo position determined by a pulsewidth between 1-2ms
            }
        }
    }

}