#include "mbed.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"

SDFileSystem sd(p11, p12, p13, p14, "sd"); //sd card
DigitalIn pb(p21); //pushbutton
uLCD_4DGL uLCD(p9,p10,p8); // serial tx, serial rx, reset pin;

int main() {
    char buffer[300]; //buffer to store the quotation
    float rando=0; //variable responsible to receive the random value
    uLCD.cls(); //clear the screen
    
    while (true){
        if (pb == 1){
            //open the file to be read
            FILE *ft = fopen("/sd/sdtest.txt", "r+");
            if(ft == NULL) {
                error("Could not open file for write\n");
            }
            rando = rand()%10+1;//random value
            for(int i=0; i<rando; i++){ //copy to buffer the quotation of the random value
                fgets(buffer, 300, ft);
            }
            uLCD.background_color(WHITE);
            uLCD.cls();
            uLCD.background_color(WHITE);
            uLCD.textbackground_color(WHITE);
            uLCD.color(BLACK);
            uLCD.printf("%s\n", buffer); //prints in the scrren the string
            fclose(ft);
            wait(0.2); 
        }
    }
}
