#include "mbed.h"
#include "m3pi.h"

#define BASE_SPEED 0.25
#define K_P 0.25

// The pi object lets us access the robot sensors, motors and LCD.
// See the user guide at: http://mbed.org/cookbook/m3pi and
//  http://mbed.org/users/chris/code/m3pi/docs/4b7d6ea9b35b/classm3pi.html
m3pi pi;

int main() {
    float left_speed, right_speed, line_position;
    
    // Display "GGC 2012" so users know they have the correct program
    pi.locate(0,0);
    pi.printf("GGC 2012");
    
    wait(0.5);

    // Auto-align the sensors on the bottom of the robot
    pi.sensor_auto_calibrate();

    while(1)
    {   // This implements proportional feedback for driving the motors
    
        // Get the position of the line: -1.0 is off to the left;
        //  +1.0 is off to the right.
        line_position = pi.line_position();
        
        // Speed for each motor can be -1.0 to +1.0. With the default values
        //  it is limited to between 0 and 0.5.
        left_speed  = BASE_SPEED - line_position*K_P;
        right_speed = BASE_SPEED + line_position*K_P;
        
        // Send new speeds to the motor controller
        pi.left_motor(left_speed);
        pi.right_motor(right_speed);
    }

    pi.stop();
}