#include "mbed.h"
#include "USBKeyboard.h"
//#include "DebouncedEdgeIn.h"

//DigitalOut ledG(LED_GREEN);
//DigitalOut ledR(LED_RED);
//DigitalOut ledB(LED_BLUE);
USBKeyboard keyboard;

//Serial pc(USBTX, USBRX);

DigitalIn diL(D2);
DigitalIn diR(D3);
//DebouncedEdgeIn diL(D2);
//DebouncedEdgeIn diR(D3);

int lVal, rVal, preL = 1, preR = 1;
int bufferIndex = 0;
int ledIndex = 0;
int alphaIndex = 0;
bool keyUpdate = false;
DigitalOut ledArray[3] = {LED_RED, LED_GREEN, LED_BLUE};
uint8_t alphaArray[31] = {'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',' ','.',8,10,'c'};


/*
void bufferAdd(char* indexVal) {
    buffer[bufferIndex] = indexVal;
    bufferIndex++;
    if (bufferIndex == 19) {
        keyUpdate = true;
        bufferIndex = 0;
    }
}
*/

void poll() {
    lVal = diL.read();
    rVal = diR.read();
}

void onRiseL(void) {
    keyUpdate = true;
    //update led value
    ledArray[ledIndex] = 0;
    
    //do alphabet update
    if (alphaIndex == 0) {
        alphaIndex = 30;
    } else {
        alphaIndex -= 1;
    }
    
    //do led update
    if (ledIndex == 0) {
        ledIndex = 2;
    } else {
        ledIndex -= 1;
    }
    
    ledArray[ledIndex] = 1;  
    //pc.puts(alphaArray[alphaIndex]);              
}

void onRiseR(void) {
    keyUpdate = true;
    //change led value
    ledArray[ledIndex] = 0;
    
    //do alphabet update
    if (alphaIndex == 30) {
        alphaIndex = 0;
    } else {
        alphaIndex += 1;
    }
    
    //do led update
    if (ledIndex == 2) {
        ledIndex = 0;
    } else {
        ledIndex += 1;
    }
    
    ledArray[ledIndex] = 1;    
    //pc.puts(alphaArray[alphaIndex]);    
}

int main()
{        
    diL.mode(PullUp);
    diR.mode(PullUp);   
    
    while (true) {
        poll();
        if (lVal == 0) {onRiseL();}
        if (rVal == 0) {onRiseR();}
        //keyboard.printf("hello from mbed.\n");
        if (keyUpdate) {
            if (alphaIndex == 30) {
                keyboard.keyCode('c', KEY_CTRL);
            } else {
                keyboard.keyCode(alphaArray[alphaIndex]);
            }
            keyUpdate = false;
            wait(0.15);
        }
    }
}
