#ifndef __BLE_ERROR_SERVICE_H__
#define __BLE_ERROR_SERVICE_H__

#include "BLEDevice.h"

/**
* @class BroadcasterService
* @brief Based heavily on the BLE Battery Services
*/
class ErrorService
{
    
public:
    enum {
        ERROR_SERVER_DISCONNECTION = 0x1234,
        ERROR_ELECTRONIC_DSICONNECTION = 0x1221,
        ERROR_GENERIC = 0x4321,
    };
    /**
    * @param[ref] _ble
    *
    * @param[in]
    */
    
    const static uint16_t ERROR_SERVICE_UUID            = 0x2A69;
    const static uint16_t ERROR_CHARACTERISTIC_UUID     = 0x1819;
    
    ErrorService(BLEDevice &_ble) : //, uint8_t _errorCode[8]
        ble(_ble),
        errorCode(), //instead of command(_command);
        
        errorCharacteristic(ERROR_CHARACTERISTIC_UUID, &errorCode, sizeof(errorCode), sizeof(errorCode),
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                  // GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE |
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
               
        static bool serviceAdded = false; /* We should only ever need to add the service once. */
        if (serviceAdded) {
            return;
        }

        GattCharacteristic *charTable[] = {&errorCharacteristic};
        GattService         errorService(ErrorService::ERROR_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));

        ble.addService(errorService);
        serviceAdded = true;
    }

    /**
     * @brief
     *
     * @param
     */
    void registerError(uint8_t _errorCode) {
        errorCode = _errorCode;
 
        //memcpy(command, _newCommand, sizeof(_newCommand));
        ble.updateCharacteristicValue(errorCharacteristic.getValueAttribute().getHandle(), &errorCode, sizeof(errorCode), false);
    }

private:
    BLEDevice               &ble;
    uint8_t                 errorCode;    
    GattCharacteristic      errorCharacteristic;
};

#endif