#ifndef __BLE_BROADCASTER_SERVICE_H__
#define __BLE_BROADCASTER_SERVICE_H__

#include "BLEDevice.h"
using namespace std;

/**
* @class BroadcasterService
* @brief Based heavily on the BLE Battery Service, the aim is to send key, pair values <br>. 
* UPDATE: Should now be sending 8-byte string - 4 bytes for Type, 4 for command
*/
class BroadcasterService
{
public:
    /**
    * @param[ref] _ble
    *
    * @param[in]
    */    
    const static uint16_t BROADCAST_SERVICE_UUID            = 0x2A67;
    const static uint16_t BROADCAST_CHARACTERISTIC_UUID     = 0x1817;
    
    BroadcasterService(BLEDevice &_ble) :
        ble(_ble),
        //command(), //instead of command(_command);
        
        broadcasterCharacteristic(BROADCAST_CHARACTERISTIC_UUID, command, sizeof(command), sizeof(command),
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
               
        static bool serviceAdded = false; /* We should only ever need to add the service once. */
        if (serviceAdded) {
            return;
        }

        GattCharacteristic *charTable[] = {&broadcasterCharacteristic};
        GattService         broadcasterService(BroadcasterService::BROADCAST_SERVICE_UUID, charTable, 
                                sizeof(charTable) / sizeof(GattCharacteristic *));

        ble.addService(broadcasterService);
        serviceAdded = true;
    }

    /**
     * @brief
     *
     * @param
     */
    void sendCommand(uint8_t _newCommand[8]) {
//        command = _newCommand;
        //std::copy_n(_newCommand, sizeof(_newCommand), command);
        memcpy(&command, &_newCommand, sizeof(_newCommand));
        ble.updateCharacteristicValue(broadcasterCharacteristic.getValueAttribute().getHandle(), command, sizeof(command), false);
    }

private:
    BLEDevice               &ble;
    uint8_t                 command[8];    
    GattCharacteristic      broadcasterCharacteristic;
};

#endif