#ifndef __BLE_BROADCASTER_SERVICE_H__
#define __BLE_BROADCASTER_SERVICE_H__

#include "BLEDevice.h"
using namespace std;
//http://ble-intros.readthedocs.org/en/latest/InDepth/BLEInDepth/


/**
* @class BroadcasterService
* @brief Based heavily on the BLE Battery Service, the aim is to send key, pair values <br>. 
* UPDATE: Should now be sending 8-byte string - 4 bytes for Type, 4 for command
*/
class BroadcasterService
{
public:

    enum {
        ERROR_SERVER_DISCONNECTION = 0x1111,
        ERROR_ELECTRONIC_DSICONNECTION = 0x1222,
        ERROR_GENERIC = 0x1234,
    };
    
    const static uint16_t BROADCAST_SERVICE_UUID            = 0x2A67;
    const static uint16_t BROADCAST_CHARACTERISTIC_UUID     = 0x1817;
    const static uint16_t ERROR_CHARACTERISTIC_UUID     = 0x1818;
    
    BroadcasterService(BLEDevice &_ble) :
        ble(_ble),
        //define characteristics
        broadcasterCharacteristic(BROADCAST_CHARACTERISTIC_UUID, command, sizeof(command), sizeof(command),
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        errorCharacteristic(ERROR_CHARACTERISTIC_UUID, &errorCode, sizeof(errorCode), sizeof(errorCode),
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ |
                                  GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
               
        static bool serviceAdded = false; /* We should only ever need to add the service once. */
        if (!serviceAdded) {
        
            GattCharacteristic *charTable[] = {&broadcasterCharacteristic, &errorCharacteristic};
            GattService         broadcasterService(BroadcasterService::BROADCAST_SERVICE_UUID, charTable, 
                                    sizeof(charTable) / sizeof(GattCharacteristic *));
    
            ble.addService(broadcasterService);
            serviceAdded = true;
        }
    }

    /**
     * @brief
     *
     * @param
     */
    void sendCommand(uint8_t _newCommand[8]) {
        memcpy(&command, &_newCommand, sizeof(_newCommand));
        
        ble.updateCharacteristicValue(broadcasterCharacteristic.getValueAttribute().getHandle(), command, sizeof(command), false);
    }
    
    void registerError(uint8_t _errorCode) {
        errorCode = _errorCode;
        
        ble.updateCharacteristicValue(errorCharacteristic.getValueAttribute().getHandle(), &errorCode, sizeof(errorCode), false);
    }

private:
    BLEDevice               &ble;
    uint8_t                 command[8];    
    uint8_t                 errorCode;   
    GattCharacteristic      broadcasterCharacteristic;
    GattCharacteristic      errorCharacteristic;
};

#endif