/************************************************************************************
   Code created using the ARMwizard, visit http://alexan.edaboard.eu 
************************************************************************************/
/*
#include <LPC11Uxx.h>
*/

#include "mbed.h"

#define LED1 1UL<<8
#define LED2 1UL<<9
#define LED3 1UL<<10
#define LED4 1UL<<11


/******************************************************************************
                  GPIO group 0 interrupt service function
******************************************************************************/
extern "C" void GINT0_IRQHandler(void) {
/* write code here */
LPC_GPIO->SET[1] = LED1;

LPC_GPIO_GROUP_INT0->CTRL |= (1UL<<0);   /* Clear pin group 0 interrupt flag */
}

/******************************************************************************
                  GPIO group 1 interrupt service function
******************************************************************************/
extern "C" void GINT1_IRQHandler(void) {
/* write code here */
LPC_GPIO->CLR[1] = LED1;

LPC_GPIO_GROUP_INT1->CTRL |= (1UL<<0);   /* Clear pin group 1 interrupt flag */
}

/******************************************************************************
                  GPIO pin interrupt 0 service function
******************************************************************************/
extern "C" void FLEX_INT0_IRQHandler(void) {
/* write code here */
LPC_GPIO->SET[1] = LED2;

/* The following clears the pin interrupt flag when set to EDGE mode, if the pin is set the LEVEL sense then remove the line */
//LPC_GPIO_PIN_INT->IST = (1UL<<0);   /* Clear RISING/FALLING EDGE interrupt flag */
}

/******************************************************************************
                  GPIO pin interrupt 1 service function
******************************************************************************/
extern "C" void FLEX_INT1_IRQHandler(void) {
/* write code here */
LPC_GPIO->CLR[1] = LED2;

/* The foillowing clears the pin interrupt flag when set to EDGE mode, if the pin is set the LEVEL sence then remove the line */
//LPC_GPIO_PIN_INT->IST = (1UL<<1);   /* Clear RISING/FALLING EDGE interrupt flag */
}

int main(void)
{
/*
    P0.0:  RESET (External reset input with 20 ns glitch filter), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.1:  PORT0.1 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.2:  PORT0.2 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.3:  PORT0.3 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.4:  PORT0.4 (General purpose I/O)  Input, I2CMODE: Standard mode/ Fast-mode I2C
    P0.5:  PORT0.5 (General purpose I/O)  Input, I2CMODE: Standard mode/ Fast-mode I2C
    P0.6:  PORT0.6 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.7:  PORT0.7 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.8:  PORT0.8 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.9:  PORT0.9 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.10:  SWCLK (Serial wire clock), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.11:  TDI (Test Data In for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.12:  TMS (Test Mode Select for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.13:  TDO (Test Data Out for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.14:  TRST (Test Reset for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.15:  SWDIO (Serial wire debug input/output), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.16:  PORT0.16 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.17:  PORT0.17 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.18:  PORT0.18 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.19:  PORT0.19 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.20:  PORT0.20 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.21:  PORT0.21 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.22:  PORT0.22 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.23:  PORT0.23 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P1.0:  PORT1.0 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.1:  PORT1.1 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.2:  PORT1.2 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.3:  PORT1.3 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.4:  PORT1.4 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.5:  PORT1.5 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.6:  PORT1.6 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.7:  PORT1.7 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.8:  PORT1.8 (General purpose I/O)  Output, neither pull-up nor pull-down, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.9:  PORT1.9 (General purpose I/O)  Output, neither pull-up nor pull-down, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.10:  PORT1.10 (General purpose I/O)  Output, neither pull-up nor pull-down, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.11:  PORT1.11 (General purpose I/O)  Output, neither pull-up nor pull-down, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.12:  PORT1.12 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.13:  PORT1.13 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.14:  PORT1.14 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.15:  PORT1.15 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.16:  PORT1.16 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.17:  PORT1.17 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.18:  PORT1.18 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.19:  PORT1.19 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.20:  PORT1.20 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.21:  PORT1.21 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.22:  PORT1.22 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.23:  PORT1.23 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.24:  PORT1.24 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.25:  PORT1.25 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.26:  PORT1.26 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.27:  PORT1.27 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.28:  PORT1.28 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.29:  PORT1.29 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
*/

    LPC_SYSCON->SYSAHBCLKDIV = 0x01;     /* set AHB clock divider to 1/1 */
    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<6);   /* enable clock for GPIO (default is disabled)*/
    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<16);   /* enable clock for IOCON (default is disabled)*/

    LPC_IOCON->RESET_PIO0_0 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_1 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_2 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_3 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_4 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO0_5 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO0_6 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_7 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_8 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_9 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->SWCLK_PIO0_10 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TDI_PIO0_11 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TMS_PIO0_12 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TDO_PIO0_13 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TRST_PIO0_14 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->SWDIO_PIO0_15 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_16 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_17 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_18 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_19 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_20 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_21 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_22 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_23 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_0 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_1 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_2 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_3 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_4 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_5 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_6 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_7 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_8 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO1_9 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO1_10 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO1_11 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO1_12 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_13 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_14 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_15 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_16 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_17 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_18 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_19 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_20 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_21 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_22 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_23 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_24 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_25 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_26 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_27 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_28 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_29 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */

    LPC_GPIO->DIR[0] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO->DIR[1] = 0x00000F00;     /* binary: 00000000_00000000_00001111_00000000 */

/******************************************************************************
                           GPIO pin interrupts
*******************************************************************************
   GPIO pin interrupt 0 set for: P0.16 triggered with LOW LEVEL
   GPIO pin interrupt 1 set for: P0.22 triggered with LOW LEVEL
*/

    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<19);   /* enable clock for GPIO pin interrupt (default is disabled)*/

    LPC_GPIO_PIN_INT->ISEL = 0x00000003;     /* binary: 00000000_00000000_00000000_00000011 */
    LPC_GPIO_PIN_INT->IENR = 0x00000003;     /* binary: 00000000_00000000_00000000_00000011 */
    LPC_GPIO_PIN_INT->IENF = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */

    LPC_SYSCON->PINTSEL[0] = 0x00000010;     /* binary: 00000000_00000000_00000000_00010000 */
    LPC_SYSCON->PINTSEL[1] = 0x00000016;     /* binary: 00000000_00000000_00000000_00010110 */

/******************************************************************************
                           GPIO group 0 interrupt
*******************************************************************************
    The following pins are combined with the AND operator
      P0.7 set for Low Level
      P0.17 set for Low Level
*/

    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<23);   /* enable clock for GPIO GROUP0 interrupt (default is disabled)*/

    LPC_GPIO_GROUP_INT0->PORT_POL[0] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO_GROUP_INT0->PORT_POL[1] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO_GROUP_INT0->PORT_ENA[0] = 0x00020080;     /* binary: 00000000_00000010_00000000_10000000 */
    LPC_GPIO_GROUP_INT0->PORT_ENA[1] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO_GROUP_INT0->CTRL = 0x00000006;     /* binary: 00000000_00000000_00000000_00000110 */

/******************************************************************************
                           GPIO group 1 interrupt
*******************************************************************************
    The following pins are combined with the OR operator
      P1.17 set for Low Level
      P1.18 set for Low Level
*/

    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<24);   /* enable clock for GPIO GROUP1 interrupt (default is disabled)*/

    LPC_GPIO_GROUP_INT1->PORT_POL[0] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO_GROUP_INT1->PORT_POL[1] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO_GROUP_INT1->PORT_ENA[0] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO_GROUP_INT1->PORT_ENA[1] = 0x00060000;     /* binary: 00000000_00000110_00000000_00000000 */
    LPC_GPIO_GROUP_INT1->CTRL = 0x00000004;     /* binary: 00000000_00000000_00000000_00000100 */
    
/******************************************************************************
                         Vectored Interrupt initialization
******************************************************************************/

   NVIC_SetPriority(GINT0_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(GINT0_IRQn);           /* Enable GPIO group 0 interrupt */

   NVIC_SetPriority(GINT1_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(GINT1_IRQn);           /* Enable GPIO group 1 interrupt */
   
   NVIC_SetPriority(FLEX_INT0_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(FLEX_INT0_IRQn);           /* Enable GPIO pin interrupt 0 */
   
   NVIC_SetPriority(FLEX_INT1_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(FLEX_INT1_IRQn);           /* Enable GPIO pin interrupt 1 */
   
   while(1)
  {
  
  
   }

}
