/************************************************************************************
   Code created using the ARMwizard, visit http://alexan.edaboard.eu 
************************************************************************************/

/*
#include <LPC11Uxx.h>
*/

#include "mbed.h"

#define LED1 1UL<<8
#define LED2 1UL<<9
#define LED3 1UL<<10
#define LED4 1UL<<11


/******************************************************************************
                  16-bit Timer0 Interrupt service function
******************************************************************************/
extern "C" void TIMER16_0_IRQHandler(void) {
/* write code here */
LPC_GPIO->PIN[1] ^= LED3;

/* list of all available flags, select which to use */
LPC_CT16B0->IR = (1UL<<0);   /* Clear MAT2.0 interrupt flag */
}

/******************************************************************************
                  16-bit Timer1 Interrupt service function
******************************************************************************/
extern "C" void TIMER16_1_IRQHandler(void) {
/* write code here */
LPC_GPIO->PIN[1] ^= LED4;

/* list of all available flags, select which to use */
LPC_CT16B1->IR = (1UL<<0);   /* Clear MAT3.0 interrupt flag */
}

/******************************************************************************
                  32-bit Timer0 Interrupt service function
******************************************************************************/
extern "C" void TIMER32_0_IRQHandler(void) {
/* write code here */
LPC_GPIO->PIN[1] ^= LED1;

/* list of all available flags, select which to use */
LPC_CT32B0->IR = (1UL<<0);   /* Clear MAT0.0 interrupt flag */
}

/******************************************************************************
                  32-bit Timer1 Interrupt service function
******************************************************************************/
extern "C" void TIMER32_1_IRQHandler(void) {
/* write code here */
LPC_GPIO->PIN[1] ^= LED2;

/* list of all available flags, select which to use */
LPC_CT32B1->IR = (1UL<<0);   /* Clear MAT1.0 interrupt flag */
}

int main(void)
{
/*
    P0.0:  RESET (External reset input with 20 ns glitch filter), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.1:  PORT0.1 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.2:  PORT0.2 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.3:  PORT0.3 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.4:  PORT0.4 (General purpose I/O)  Input, I2CMODE: Standard mode/ Fast-mode I2C
    P0.5:  PORT0.5 (General purpose I/O)  Input, I2CMODE: Standard mode/ Fast-mode I2C
    P0.6:  PORT0.6 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.7:  PORT0.7 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.8:  PORT0.8 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.9:  PORT0.9 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.10:  SWCLK (Serial wire clock), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.11:  TDI (Test Data In for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.12:  TMS (Test Mode Select for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.13:  TDO (Test Data Out for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.14:  TRST (Test Reset for JTAG interface), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.15:  SWDIO (Serial wire debug input/output), pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.16:  PORT0.16 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.17:  PORT0.17 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.18:  PORT0.18 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.19:  PORT0.19 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.20:  PORT0.20 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.21:  PORT0.21 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P0.22:  PORT0.22 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P0.23:  PORT0.23 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Digital mode, Open Drain disabled
    P1.0:  PORT1.0 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.1:  PORT1.1 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.2:  PORT1.2 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.3:  PORT1.3 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.4:  PORT1.4 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.5:  PORT1.5 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.6:  PORT1.6 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.7:  PORT1.7 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.8:  PORT1.8 (General purpose I/O)  Output, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.9:  PORT1.9 (General purpose I/O)  Output, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.10:  PORT1.10 (General purpose I/O)  Output, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.11:  PORT1.11 (General purpose I/O)  Output, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.12:  PORT1.12 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.13:  PORT1.13 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.14:  PORT1.14 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.15:  PORT1.15 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.16:  PORT1.16 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.17:  PORT1.17 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.18:  PORT1.18 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.19:  PORT1.19 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.20:  PORT1.20 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.21:  PORT1.21 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.22:  PORT1.22 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.23:  PORT1.23 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.24:  PORT1.24 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.25:  PORT1.25 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.26:  PORT1.26 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.27:  PORT1.27 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.28:  PORT1.28 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
    P1.29:  PORT1.29 (General purpose I/O)  Input, pull-up resistor enabled, Hysteresis disabled, Input not inverted, Open Drain disabled
*/

    LPC_SYSCON->SYSAHBCLKDIV = 0x01;     /* set AHB clock divider to 1/1 */
    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<6);   /* enable clock for GPIO (default is disabled)*/
    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<16);   /* enable clock for IOCON (default is disabled)*/

    LPC_IOCON->RESET_PIO0_0 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_1 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_2 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_3 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_4 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO0_5 = 0x00000080;     /* binary: 00000000_00000000_00000000_10000000 */
    LPC_IOCON->PIO0_6 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_7 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_8 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_9 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->SWCLK_PIO0_10 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TDI_PIO0_11 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TMS_PIO0_12 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TDO_PIO0_13 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->TRST_PIO0_14 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->SWDIO_PIO0_15 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_16 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_17 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_18 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_19 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_20 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_21 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_22 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO0_23 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_0 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_1 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_2 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_3 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_4 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_5 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_6 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_7 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_8 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_9 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_10 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_11 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_12 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_13 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_14 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_15 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_16 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_17 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_18 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_19 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_20 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_21 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_22 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_23 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_24 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_25 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_26 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_27 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_28 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */
    LPC_IOCON->PIO1_29 = 0x00000090;     /* binary: 00000000_00000000_00000000_10010000 */

    LPC_GPIO->DIR[0] = 0x00000000;     /* binary: 00000000_00000000_00000000_00000000 */
    LPC_GPIO->DIR[1] = 0x00000F00;     /* binary: 00000000_00000000_00001111_00000000 */

/******************************************************************************
                         Vectored Interrupt initialization
******************************************************************************/

   NVIC_SetPriority(TIMER_16_0_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(TIMER_16_0_IRQn);           /* Enable 16-bit Timer0 Interrupt */
   
   NVIC_SetPriority(TIMER_16_1_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(TIMER_16_1_IRQn);           /* Enable 16-bit Timer1 Interrupt */
   
   NVIC_SetPriority(TIMER_32_0_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(TIMER_32_0_IRQn);           /* Enable 32-bit Timer0 Interrupt */
   
   NVIC_SetPriority(TIMER_32_1_IRQn,0);          /* Default priority group 0, can be 0(highest) - 3(lowest) */
   NVIC_EnableIRQ(TIMER_32_1_IRQn);           /* Enable 32-bit Timer1 Interrupt */
   
/******************************************************************************
                             Timer0(CT32B0) (32bit)
*******************************************************************************
   Counter Enabled,    Counter Reset=0
   Timer mode: count on rising edge of PCLK
   Counter clk: 1 KHz, Counts every: 1000 us  (calculated with peripheral clock: 48MHz)
   MCR0.0 : reset, generate interrupt on compare match
*/

    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<9);    /* Enable clock for CT32B0 (default is disabled) */

    LPC_CT32B0->CTCR = 0x00;     /* binary: 00000000 */
    LPC_CT32B0->TC = 0x00000000;     /* decimal 0 */
    LPC_CT32B0->PR = 0x0000BB7F;     /* decimal 47999 */
    LPC_CT32B0->MCR = 0x0003;     /* binary: 00000000_00000011 */
    LPC_CT32B0->MR0 = 0x00000064;     /* decimal 100 */
    LPC_CT32B0->MR1 = 0x00000000;     /* decimal 0 */
    LPC_CT32B0->MR2 = 0x00000000;     /* decimal 0 */
    LPC_CT32B0->MR3 = 0x00000000;     /* decimal 0 */
    LPC_CT32B0->CCR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT32B0->EMR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT32B0->TCR = 0x01;     /* binary: 00000001 */

/******************************************************************************
                             Timer1(CT32B1) (32bit)
*******************************************************************************
   Counter Enabled,    Counter Reset=0
   Timer mode: count on rising edge of PCLK
   Counter clk: 1 KHz, Counts every: 1000 us  (calculated with peripheral clock: 48MHz)
   MCR1.0 : reset, generate interrupt on compare match
*/

    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<10);    /* Enable clock for CT32B1 (default is disabled) */

    LPC_CT32B1->CTCR = 0x00;     /* binary: 00000000 */
    LPC_CT32B1->TC = 0x00000000;     /* decimal 0 */
    LPC_CT32B1->PR = 0x0000BB7F;     /* decimal 47999 */
    LPC_CT32B1->MCR = 0x0003;     /* binary: 00000000_00000011 */
    LPC_CT32B1->MR0 = 0x000000C8;     /* decimal 200 */
    LPC_CT32B1->MR1 = 0x00000000;     /* decimal 0 */
    LPC_CT32B1->MR2 = 0x00000000;     /* decimal 0 */
    LPC_CT32B1->MR3 = 0x00000000;     /* decimal 0 */
    LPC_CT32B1->CCR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT32B1->EMR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT32B1->TCR = 0x01;     /* binary: 00000001 */

/******************************************************************************
                             Timer2(CT16B0) (16bit)
*******************************************************************************
   Counter Enabled,    Counter Reset=0
   Timer mode: count on rising edge of PCLK
   Counter clk: 1 KHz, Counts every: 1000 us  (calculated with peripheral clock: 48MHz)
   MCR2.0 : reset, generate interrupt on compare match
*/

    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<7);    /* Enable clock for CT16B0 (default is disabled) */

    LPC_CT16B0->CTCR = 0x00;     /* binary: 00000000 */
    LPC_CT16B0->TC = 0x0000;     /* decimal 0 */
    LPC_CT16B0->PR = 0xBB7F;     /* decimal 47999 */
    LPC_CT16B0->MCR = 0x0003;     /* binary: 00000000_00000011 */
    LPC_CT16B0->MR0 = 0x0190;     /* decimal 400 */
    LPC_CT16B0->MR1 = 0x0000;     /* decimal 0 */
    LPC_CT16B0->MR2 = 0x0000;     /* decimal 0 */
    LPC_CT16B0->MR3 = 0x0000;     /* decimal 0 */
    LPC_CT16B0->CCR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT16B0->EMR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT16B0->TCR = 0x01;     /* binary: 00000001 */

/******************************************************************************
                             Timer3(CT16B1) (16bit)
*******************************************************************************
   Counter Enabled,    Counter Reset=0
   Timer mode: count on rising edge of PCLK
   Counter clk: 1 KHz, Counts every: 1000 us  (calculated with peripheral clock: 48MHz)
   MCR3.0 : reset, generate interrupt on compare match
*/

    LPC_SYSCON->SYSAHBCLKCTRL = (LPC_SYSCON->SYSAHBCLKCTRL & 0x098DFFFF) | (1UL<<8);    /* Enable clock for CT16B1 (default is disabled) */

    LPC_CT16B1->CTCR = 0x00;     /* binary: 00000000 */
    LPC_CT16B1->TC = 0x0000;     /* decimal 0 */
    LPC_CT16B1->PR = 0xBB7F;     /* decimal 47999 */
    LPC_CT16B1->MCR = 0x0003;     /* binary: 00000000_00000011 */
    LPC_CT16B1->MR0 = 0x0320;     /* decimal 800 */
    LPC_CT16B1->MR1 = 0x0000;     /* decimal 0 */
    LPC_CT16B1->MR2 = 0x0000;     /* decimal 0 */
    LPC_CT16B1->MR3 = 0x0000;     /* decimal 0 */
    LPC_CT16B1->CCR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT16B1->EMR = 0x0000;     /* binary: 00000000_00000000 */
    LPC_CT16B1->TCR = 0x01;     /* binary: 00000001 */

   while(1)
  {
  
  
   }

}
