/*
 * ECHO communication between Bluetooth and RS232
 * Using mBED Landtiger Card
 * Based on HC05 work by:
 * Author: Edoardo De Marchi
 * Date: 11-08-14
 * Notes: HC05 Trasparent Mode
*/

//mBED Complete libraries
#include "mbed.h"

//Serial Pin port configurations
//pc - RS232 serial port, blue - bluetootk serial port
    Serial pc(P0_10, P0_11);        //tx, rx pins for the Landtiger, use COM2 UART2 connector direct from the card
    Serial blue(P0_2, P0_3);         // UART0_TX, UART0_RX for the LandTiger. Connect a BT module to these pins

//Define activity leds for RS232 and BT
    DigitalOut myled4(P2_7);//landtiger LEDS LD4, LD5
    DigitalOut myled5(P2_6);
    BusOut LEDS(P2_5, P2_4, P2_3, P2_2, P2_1, P2_0); //landtiger all leds

int temp;

//Main routine
int main() 
{
    //Serial ports initialization
    blue.baud(9600);
    pc.baud(9600);
    pc.printf("Bluetooth Start\r\n");
    blue.printf("Communication Start \r\n\0");
    LEDS = 0; //turn off other leds
    
    // echo back characters and toggle the LED
    while (1) 
    {
        if (blue.readable()) 
        {
            temp = blue.getc(); //reads BT one character
            pc.putc(temp);      // puts character in serial
            blue.putc(temp);    //echo BT
            myled4 = !myled4;   //Led BT activity
        }
        if (pc.readable()) 
        {
            temp = pc.getc(); //reads RS232 one character
            blue.putc(temp);  //puts character thru BT
            pc.putc(temp);    // echo serial
            blue.printf("\0");  //null character to empty BT buffer      
            myled5 = !myled5; // RS232 activity led
        }
        
    }
}
