/* simple program to exercise all LEDS and switch
* using the LandTiger Board
*/

#include "mbed.h"
//Create a Bus with the 8 LEDS. Pins corresponds to LD4 to LD11
BusOut LEDS(P2_7, P2_6, P2_5, P2_4, P2_3, P2_2, P2_1, P2_0);

//LEDS OUT
DigitalOut LED_4(P2_7);  
DigitalOut LED_5(P2_6);  
DigitalOut LED_6(P2_5);  
DigitalOut LED_7(P2_4); 
DigitalOut LED_8(P2_3);  
DigitalOut LED_9(P2_2);
DigitalOut LED_10(P2_1);  
DigitalOut LED_11(P2_0);

//PUSHBUTTON IN
DigitalIn KEY1(P2_11);
DigitalIn KEY2(P2_12);
DigitalIn INT0(P2_10);

//KNOB IN
DigitalIn UP(P1_29);
DigitalIn DOWN(P1_26);
DigitalIn LEFT(P1_27);
DigitalIn RIGHT(P1_28);
DigitalIn SELECT(P1_25);

 
int main() {
    LEDS=0;//turn off all LEDS
    while(1) {
        //make one input an output
        //The switchs are normally HIGH, when pressed are LOW
        //program displays all leds ON, turns off when button is pressed
        LED_4 = KEY1;  
        LED_5 = KEY2;  
        LED_6 = INT0;  
        LED_7 = UP; 
        LED_8 = DOWN;  
        LED_9 = LEFT;
        LED_10 = RIGHT;  
        LED_11 = SELECT;
        
        wait(0.2);
    }
}
