#ifndef CAR_H
#define CAR_H

#include "mbed.h"
#include "Utils.h"
#include "N5110.h"
#include "Vector.h"
#include "Joystick.h"
#include <cmath> 

const static int STRAIGHT = 0;
const static int RIGHT = 1;
const static int LEFT = 2;

class Car
{
public:

    Car();
    void init(int direction, int magnitude, int start_pos);
    int get_direction(float coord_x);
    int get_magnitude(float coord_x);
    void draw(N5110 &lcd, int start_pos, float start_angle);
    
private:

    int _direction;
    int _magnitude;
    int _start_pos;
};
#endif 