#ifndef UTILS_H
#define UTILS_H

#include "mbed.h"
#include "N5110.h"
#include "Vector.h"

class Utils
{
  public:
  
   Utils();
   
   /* Linear Interpolation
    * This function implements the "smooth" connectivity between two points
    * @param term0     - first term of the equation
    * @param term1     - second term of the equation
    * @param perc     - percentage at which we increase: always between 0 and 1.0
    */
   float curveEquation(float const term0, 
                       float const term1, 
                       float perc);
  
   /** Take points from curve
    *
    *   This function takes all the points from a curve and stores them in a vector
    *   @param  x0     - x-coordinate of first point
    *   @param  y0     - y-coordinate of first point
    *   @param  x1     - x-coordinate of second point
    *   @param  y1     - y-coordinate of second point
    *   @param  x2     - x-coordinate of third point
    *   @param  y2     - y-coordinate of third point
    */
   std::vector<Vector2Df> getCurve(float const x0,
                                   float const y0,
                                   float const x1,
                                   float const y1,
                                   float const x2,
                                   float const y2);
   
};

#endif