#ifndef ROAD_H
#define ROAD_H

#include "mbed.h"
#include "Utils.h"
#include "N5110.h"
#include <cmath> 
#include <vector>
#include "Vector.h"

class Road
{
public:

    Road();
    void init(float direction, float inclination);
    void set_inclination(float inclination);
    void draw(N5110 &lcd, Utils &utils, float direction, float offset);
    void draw_warn(N5110 &lcd, int warn_position);

private:

    float _inclination;
    float _direction;

};
#endif 