#include "Road.h"

// constructure
Road::Road() {}

void Road::init(float direction, float inclination) {    
    //initialize parameters
    _direction = direction;
    _inclination = inclination;
}

void Road::set_inclination(float inclination) {
    _inclination = inclination; 
    }

void Road::draw(N5110 &lcd, Utils &utils, float direction, float offset) { 
    // direction is i in the main code
    // use "+= or -= speed" to get the direction of the road
    lcd.drawLine (0,12,84,12,0,1);
    std::vector<Vector2Df> curve_points_1 = utils.getCurve(12,48,20 + 5 * direction, 30 - abs(direction),28,12);    // LEFT
    std::vector<Vector2Df> curve_points_2 = utils.getCurve(72,48,64 + 5 * direction, 30 - abs(direction),56,12);    // RIGHT
    std::vector<Vector2Df> curve_points_3 = utils.getCurve(42,48,42 + 5 * direction, 30 - abs(direction),42,12);    // MIDDLE
        
    lcd.drawCurve(curve_points_1, 0, 1, TYPE_SOLID);
    lcd.drawCurve(curve_points_2, 0, 1, TYPE_SOLID);
    lcd.drawCurve(curve_points_3, offset, 1, TYPE_DOTTED);
}

    
void Road::draw_warn(N5110 &lcd, int warn_position) {
    const int warn_sign[12][12] = {
        { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
    };
    
    // if ball comes from the left side
    if (warn_position == 0) {
        lcd.drawSprite(0,18,12,12,(int *)warn_sign); 
    }
    
    // if ball comes from the top
    if (warn_position == 1) {
        lcd.drawSprite(36,0,12,12,(int *)warn_sign); 
    }
    
    // if ball comes from the right side
    if (warn_position == 2) {
        lcd.drawSprite(72,18,12,12,(int *)warn_sign); 
    }
}
    
