#ifndef GAMEENGINE_H
#define GAMEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Ball.h"
#include "Utils.h"
#include "Road.h"
#include "Car.h"
#include "Vector.h"    

class GameEngine 
{
public:
    
    GameEngine();     
        
    /** Initialize game
    *   @param  road_direction     - set up the road as STRAIGHT (0)
    *   @param  road_inclination   - set up the inclination of the road as 0
    *   @param  radius             - set the ball radius as 4
    *   @param  ball_path          - initial the ball start position
    *   @param  car_direction      - set up the car view as STRAIGHT (0)
    *   @param  car_magnitude      - set up the car tilt as 0
    *   @param  car_start_pos      - set up the car position as 38 (right in the centre)
    *   @param  road_offset        - should increase continuously 
    *   @param  car_turn           - the angle at which the car turns
    *   @param  ball_it            - the iterator that draws the ball
    **/
    void init(int road_direction, 
              int road_inclination, 
              int radius, 
              std::vector<Vector2Df> ball_path,
              int car_direction, 
              int car_magnitude, 
              int car_start_pos, 
              float road_offset, 
              float car_turn, 
              float ball_it);
                  
    int check_collision();   
    void update(float car_coord);
    void sign(N5110 &lcd, Road &road);
    void reset_ball();
    void draw(N5110 &lcd, Utils &utils);
    void generate_road(float tilt);  
    void generate_ball(int start);  
    
    
private:

    Ball _ball;
    Road _road;
    Car _car;
    Utils _utils;
    
    float _road_offset;                     // Road
    float _road_direction;                  // Road, i
    int _road_inclination;                  // Road
    float _ball_it;                         // Ball, it
    int _radius;                            // Ball
    std::vector<Vector2Df> _ball_path;      // Ball
    int _iterator;                        // Ball
    int _car_direction;                     // Car
    int _car_magnitude;                     // Car
    float _car_start_pos;                   // Car
    float _car_turn;                        // Car, y
    
};
#endif