#include "Utils.h"
#include <vector>

// constructure
Utils::Utils() {}

// Bezier equation to get the curve with one point reference
// lepr function
float Utils::curveEquation(float const term0, 
                           float const term1, 
                           float perc)
{ 
    float diff = term1 - term0;
    return term0 + ( diff * perc );
}


//funtion to get the points using Bezier curve
std::vector<Vector2Df> Utils::getCurve(float const x0,
                                       float const y0,
                                       float const x1,
                                       float const y1,
                                       float const x2,
                                       float const y2)
{  
    // vertor that will store all points 
    std::vector<Vector2Df> curve_points;
    for(float i = 0 ; i <= 1 ; i += 0.05)
    {
        float xa, ya, xb, yb; 
        xa = curveEquation(x0 , x1 , i);
        ya = curveEquation(y0 , y1 , i);
        xb = curveEquation(x1 , x2 , i);
        yb = curveEquation(y1 , y2 , i);
        
        //                                x - coord                  y - coord
        Vector2Df point = {curveEquation(xa , xb , i),curveEquation(ya , yb , i)};
        curve_points.push_back(point);
    }
    
    return curve_points;    
}