#include "GameEngine.h"

// constructure
GameEngine::GameEngine() {}    

void GameEngine::init(int road_direction, 
                      int road_inclination, 
                      int radius, 
                      std::vector<Vector2Df> ball_path,
                      int car_direction, 
                      int car_magnitude, 
                      int car_start_pos, 
                      float road_offset, 
                      float car_turn, 
                      float ball_it)
{    
    _road_direction = road_direction;
    _road_inclination = road_inclination;
    _radius = radius; 
    _ball_path = ball_path;
    _car_direction = car_direction;
    _car_magnitude = car_magnitude;
    _car_start_pos = car_start_pos;
    _road_offset = road_offset; 
    _car_turn = car_turn;
    _ball_it = ball_it;
    
    // initialize all the parameters from the game  
    _ball.init(_radius);
    _road.init(_road_direction, _road_inclination);
    _car.init(_car_direction, _car_magnitude, _car_start_pos);
}


void GameEngine::update(float car_coord) {  

    // Get the user input to know where to draw the car
    _car_direction = _car.get_direction(car_coord); 
    _car_magnitude = _car.get_magnitude(car_coord); 
    
    if(_car_direction == 0) {       // STRAIGHT
        _car_turn = 0;
    }  
    if(_car_direction == 2) {       // LEFT
        if(_car_magnitude == 1) {
            _car_turn = 4.0;
        }
        if(_car_magnitude == 2) {   
            _car_turn = 6.0;
        }
        _car_start_pos -=  0.2 * _car_magnitude; 
    }          
    if(_car_direction ==  1) {      // RIGHT
        if(_car_magnitude == 1) {
            _car_turn = 4.0;
        }
        if(_car_magnitude == 2) {
            _car_turn = 6.0;
        }
        _car_start_pos += 0.2 * _car_magnitude;
    }
    
    // Define boundaries for car movement
    if(_car_start_pos < 22.0) {
        _car_start_pos = 22.0;
    }   
    if(_car_start_pos > 55.0) {
        _car_start_pos = 55.0;
    } 

    // Make sure that middle line on road is moving continuously 
   _road_offset += 0.01;
   
   
    if(_ball_it < _ball_path.size()){
        _ball_it += 0.3;
        // Get the ball generation function 
        _iterator = static_cast<int>(_ball_path.size() - _ball_it); 
    }
    else {
        _iterator = 0;
    }
}

void GameEngine::reset_ball() {
    _ball_it = 0;    
}


void GameEngine::draw(N5110 &lcd, Utils &utils) {
    _road.draw(lcd, utils, _road_direction, _road_offset);
    _ball.draw(lcd, _ball_path, _radius, _iterator);
    _car.draw(lcd, _car_start_pos, _car_turn);
}


int GameEngine::check_collision() {
    if (static_cast<int>(_ball_path[_iterator].y) > 38
        && static_cast<int>(_ball_path[_iterator].y) < 46
        && static_cast<int>(_ball_path[_iterator].x) <= _car_start_pos + 12
        && static_cast<int>(_ball_path[_iterator].x) >= _car_start_pos - 2)
    {
        return 1;   
    }

    
    else {
        return 0;   
    }
} 
   
    
void GameEngine::generate_road(float tilt) {  

    if (_road_direction < tilt - 0.05) {
        _road_direction += 0.05;
    }
        
    else if (_road_direction > tilt + 0.05) {
        _road_direction -= 0.05;
    }    
    
    else {
        _road_direction = tilt;
    }
}

void GameEngine::generate_ball(int start){
    std::vector<Vector2Df> ball_path = _utils.getCurve(42 + start,48,42 + 5 * _road_direction + start, 30 - abs(_road_direction),42 + start,12);
    _ball_path = ball_path;
}