#include "Car.h"

// constructure
Car::Car() {}

void Car::init(int direction, int magnitude, int start_pos) {    
    // initialize parameters
    // direction = STRAIGHT;
    // magnitude = 0; 
    // start_pos = 38
    _direction = direction;
    _magnitude = magnitude;
    _start_pos = start_pos;
}


int Car::get_direction(float coord_x) {

    if (coord_x > 0.2) {
        _direction = RIGHT;       
    } 
    else if(coord_x < -0.2) {
        _direction = LEFT;
    }
    else {
        _direction = STRAIGHT;
    } 
    return _direction;
}

    
int Car::get_magnitude(float coord_x) {
    
    if(coord_x > -0.2 && coord_x < 0.2) {
        _magnitude = 0;
    } 
    else if(coord_x > 0.8 || coord_x < -0.8) {
        _magnitude = 2;
    }    
    else {
        _magnitude = 1;
    } 
    return _magnitude;
}


void Car::draw(N5110 &lcd, int start_pos, float start_angle) { 
    int x = start_pos;
    int y = static_cast<int>(start_angle);
    
    const int rear_face[12][10] = {
        { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 1, 1, 1, 1, 1, 1, 0, 1 },
        { 1, 0, 1, 0, 0, 0, 0, 1, 0, 1 },
        { 1, 0, 1, 1, 1, 1, 1, 1, 0, 1 },
        { 1, 0, 1, 0, 0, 0, 0, 1, 0, 1 },
        { 1, 0, 1, 1, 1, 1, 1, 1, 0, 1 },
        { 1, 0, 1, 0, 0, 0, 0, 1, 0, 1 },
        { 1, 0, 1, 1, 1, 1, 1, 1, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 1, 1, 1, 1, 0, 0, 1 },
        { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
    };
    
    const int front_face[12][10] = {
        { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
    };
    
    const int wheel[6][4] = {
        { 1, 1, 1, 1 },
        { 1, 0, 0, 1 },
        { 1, 0, 0, 1 },
        { 1, 0, 0, 1 },
        { 1, 0, 0, 1 },
        { 1, 1, 1, 1 },
    };
    
    const int window[10][10] = {
        { 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 0, 1, 0, 0, 0, 0, 0, 0, 1, 0 },
        
    };
    
    switch(_direction) {
        case STRAIGHT:
            lcd.drawSprite(x,26,10,10,(int *)window); 
            lcd.drawLine(x,42,x + 9,42,0,1);                   // front face
            
            //      3____4
            //      |    |      Car corners
            //      |    |
            //      |____|
            //      1    2
            
            lcd.drawSprite(x - 2,36,6,4,(int *)wheel);          // wheel 3
            lcd.drawSprite(x + 8,36,6,4,(int *)wheel);          // wheel 4
            lcd.drawSprite(x - 2,40,6,4,(int *)wheel);          // wheel 1
            lcd.drawSprite(x + 8,40,6,4,(int *)wheel);          // wheel 2
            
            lcd.drawLine(x,32,x,26,0,1);                        // line to connect corner 1
            lcd.drawLine(x + 9,32,x + 9,26,0,1);                // line to connect corner 2
            lcd.drawLine(x,42,x,38,0,1);                        // line to connect corner 3
            lcd.drawLine(x + 9,42,x + 9,38,0,1);                // line to connect corner 4
               
            lcd.drawSprite(x,32,12,10,(int *)rear_face);
            break;
            
        case RIGHT:
            lcd.drawSprite(x + y + 2,26,10,10,(int *)window); 
            // lcd.drawSprite(x + y,26,12,10,(int *)front_face);
            lcd.drawLine(x + y,26,x + y + 9,26,0,1);            // front face  
            lcd.drawLine(x + y + 9,26,x + y + 9,36,0,1);        // front face  
            
            lcd.drawSprite(x + y - 2,36,6,4,(int *)wheel);      // wheel 3
            lcd.drawSprite(x - 2,40,6,4,(int *)wheel);          // wheel 1 
            
            lcd.drawLine(x,42,x + y,38,0,1);                    // line to connect corner left bottom
            lcd.drawLine(x + 9,42,x + y + 9,38,0,1);            // line to connect corner right bottom
            
            lcd.drawSprite(x + y + 8,36,6,4,(int *)wheel);      // wheel 4
            
            lcd.drawLine(x,32,x + y,26,0,1);                    // line to connect corner left up
            lcd.drawLine(x + 9,32,x + y + 9,26,0,1);            // line to connect corner right up
            
            lcd.drawSprite(x,32,12,10,(int *)rear_face);
            lcd.drawSprite(x + 8,40,6,4,(int *)wheel);          // wheel 2
            
            break; 
            
        case LEFT:
            lcd.drawSprite(x - y - 2,26,10,10,(int *)window);
            lcd.drawLine(x - y,26,x - y + 9,26,0,1);            // front face  
            lcd.drawLine(x - y,26,x - y,36,0,1);                // front face 
            
            lcd.drawSprite(x - y + 8,36,6,4,(int *)wheel);      // wheel 4
            lcd.drawSprite(x + 8,40,6,4,(int *)wheel);          // wheel 2
            
            lcd.drawLine(x + 9,42,x - y + 9,38,0,1);            // line to connect corner right bottom
            lcd.drawLine(x,42,x - y,38,0,1);                    // line to connect corner left bottom
            
            lcd.drawSprite(x - 2 - y,36,6,4,(int *)wheel);      // wheel 3
            
            lcd.drawLine(x,32,x - y,26,0,1);                    // line to connect corner right up
            lcd.drawLine(x + 9,32,x - y + 9,26,0,1);            // line to connect corner left up
            
            lcd.drawSprite(x,32,12,10,(int *)rear_face);
            lcd.drawSprite(x - 2,40,6,4,(int *)wheel);          // wheel 1
            
            break;  
    }
}