#include "Joystick.h"

AnalogIn hin(p19);
AnalogIn vin(p18);

joyhv last = {0.5,0.5};

double scaleb(double min, double max, double bmin, double bmax, double num){
    double shifted = num + (bmin - min);    //shifted bmin down to min
    return (shifted - min) * (bmax-bmin)/(max-min) + min; //scaled bmax to max
}

double doscale(double pos){
    double min, max, midmin, midmax, scaled;
    
    min = 0.087;
    max = 0.98;
    
    midmin = 0.49;
    midmax = 0.57;

    
    if(pos < midmin){           // lower than 0.5 tolerance - backwards
        scaled = scaleb(min, midmin, 0, 0.5, pos);
    } else if (pos > midmax){   //greater than 0.5 tolerance - forwards
        scaled = scaleb(midmax, max, 0.5, 1, pos);
    } else {
        scaled = 0.5;
    }
    
    //check if out of bounds [0,1]
    
    if(scaled < 0)
        scaled = 0;
    
    if(scaled > 1)
        scaled = 1;
    
    return scaled;
}


double dofilter(double last, double num, double factor){

    return last*factor + num*(1-factor);

}

Joystick::Joystick(PinName b, PinName h, PinName v) : _b(b), _h(h), _v(v) {
}

Joystick::operator joyhv (){
    joyhv data;
    data.v = _v.read();
    data.h = _h.read();
    return data;
}

double Joystick::getV (){
    return _v.read();
}

double Joystick::getH (){
    return _h.read();
}

void Joystick::rise (void (*fptr)(void)){ 
    _b.rise(fptr);
}

void Joystick::fall (void (*fptr)(void)){
    _b.fall(fptr);
}

//simple filtering
joyhv Joystick::filter(joyhv read, double factor){

    joyhv filtered = {0.5,0.5};
    
    filtered.v = dofilter(last.v, read.v, factor);
    filtered.h = dofilter(last.h, read.h, factor);
    
    last.v = filtered.v;
    last.h = filtered.h;
    
    return filtered;
}

joyhv Joystick::scale(joyhv read){
    
    joyhv scaled = {0.5,0.5};
    
    scaled.v = doscale(read.v);
    scaled.h = doscale(read.h);
    
    return scaled;
    
}