#include "mbed.h"
#include "TextLCD.h"

Serial xbee1(p9, p10);
DigitalOut rst1(p11);

DigitalOut myled(LED1);
DigitalOut myled2(LED2);

TextLCD lcd(p16, p15, p14, p17, p18, p19, p20); // rs, rw, e, d0, d1, d2, d3

int main() {
    rst1 = 0;   //Set reset pin to 0
    myled = 0;
    myled2= 0;
    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);

    lcd.printf("starting");
    wait(2);
    lcd.cls();

    int a = 0;
    int prev = 0;

    while (1) {

        if(xbee1.readable()){
            prev = a;
            a = xbee1.getc(); //XBee read
            
            if (a != prev){
                if (a < 10){
                    lcd.printf("%d", a);
                }
                if (a == 254 || a == 253){
                    lcd.cls();
                }
            }
        }
    }
}
