#include "mbed.h"
#include "Servo.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

char code[] = "1234";

Serial pc(USBTX, USBRX);      // debugging

//--------------- IC2 trial ---------------

const int address = 0x30;

// write value into register regno, return success
bool write_reg(int regno, int value)
{
  char data[2] = {regno, value}; 
  return i2c.write(address, data, 2) == 0;
}

// read value from register regno, return success
bool read_reg(int regno, int *value)
{
  char data = regno; 
  if (i2c.write(address, &data, 1) == 0 && i2c.read(address, &data, 1) == 0)
  {
    *value = data;
    return true;
  }
  return false;
}

// read complete value of X axis, return it or -1 on failure
int read_x()
{
  int low, high;
  if ( read_reg(XOUT_H, &high) && read_reg(XOUT_L, &low) )
    return high<<8 | low;
  else
    return -1;
}

void accData(){

    DigitalOut enable(p26);    //enable pin
    I2C i2c(p28, p27);         // accelerometer
    
    enable = 1; //set enable pin to 1
    i2c.frequency(400000); //set frequency to 400 KHz
    
    const int CTRL_REGB = 0x0D;
    const int CTRL_REGC = 0x0C;
    
    write_reg(CTRL_REGB, 0xC2);
    write_reg(CTRL_REGC, 0x00);
    printf("X axis: %d\n", read_x());
    

    
    /*
    const int address = 0x97; //slave address
    
    char data[12];
    
    data[0] = 0x42;
    i2c.write(CTRL_REGB, data, 1); // register CTRL_REGB to 0x42 (start condition)
    
    wait(0.1);
    
    data[0] = 0x00;
    i2c.write(CTRL_REGC, data, 1); // register CTRL_REGC to 0x00 (start condition)
    
    wait(0.1);
    
    data[0] = 0x00;
    i2c.write(address, data, 1); // tell accelerometer i want to talk to it?

    wait(0.1);
    
    const int XOUT_H = 0x00; //x high register
    const int XOUT_L = 0x01; //x low register

    for(int i = 0; i < 10; i++){
        pc.printf("x high: '%s'\n", i2c.read(XOUT_H, data, 12));
        wait(0.1);
        pc.printf("x low: '%s'\n", i2c.read(XOUT_L, data, 12));
        wait(0.1);
    }

    enable = 0;

    
    pc.printf("started\n");
    
    
    for (int i = 0; i < 10; i++){ //get 10 results
    
        const int CTRL_REGB = 0x0D;
        const int CTRL_REGC = 0x0C;

        cmd[0] = 0x2;
        i2c.write(addr, data, 2);
        
        i2c.read(addr, data, 8); // read the echo result

        // print the ranging data to the screen
        //float echo = 0.01 * ((cmd[0] << 8) + cmd[1]);
        
        pc.printf ("Data: %s\n", cmd);

        wait(0.1);
    }
    
    i2c.write(
    
    wait(0.07);
    
    const int XOUT_H = 0x00;
    const int XOUT_L = 0x01;
    
    i2c.read(XOUT_H, data, 8); // read the result
    pc.printf ("XOUT_H: '%s'\n", data);
    
    wait(0.07);
    
    i2c.read(XOUT_L, data, 8); // read the result
    pc.printf ("XOUT_L: '%s'\n", data);    
    */

}


//--------------- Servo position reset ---------------

void resetServo(){

Servo myServo (p21);          // steering servo

  int i;
  bool j = 0;

  //clockwise 180
  for (i=0 ; i<200 ; i++){
    myServo = i/100.0;
    wait (0.01);
    if(i%10==0){
        j = !j;
        myled1 = j;
    }
  }
  
  pc.printf("Servo at full rotation\n");
  
  //wait a second
  for (i = 0; i < 10; i++){
     wait (0.1);
     j = !j;
     myled2 = j;
  }
  
  pc.printf("End pause\n");
  
  //back to start
  for (i=100 ; i>0 ; i--){
    myServo = i/100.0;
    wait (0.01);
    if(i%10==0){
        j = !j;
        myled3 = j;
    }
  }
  pc.printf("Servo at default position\n");
}

//--------------- Turning all LEDs off or on ---------------

void all(bool status){

        myled1 = status;
        myled2 = status;
        myled3 = status;
        myled4 = status;
        
}


//--------------- Digital pin checking ---------------

void checkPin5(){

DigitalIn input5(p5);

//check for pin 5
  while(1) {
      if(input5){
          myled4 = !myled4;
          pc.printf("pin 5 in!\n");
      }
      wait(0.1);
  }
}

//--------------- Get key number ---------------

int keyNum(){

DigitalIn col1(p18);
DigitalIn col2(p20);
DigitalIn col3(p16);

DigitalOut row1(p19);
DigitalOut row2(p14);
DigitalOut row3(p15);
DigitalOut row4(p17);

    row1 = 1;
    row2 = 0;
    row3 = 0;
    row4 = 0;
    
    if (col1)
        return 1;
    else if (col2)
        return 2;
    else if (col3)
        return 3; 
        
    row1 = 0;
    row2 = 1;
    row3 = 0;
    row4 = 0;
    
    if (col1)
        return 4;
    else if (col2)
        return 5;
    else if (col3)
        return 6;     
    
    row1 = 0;
    row2 = 0;
    row3 = 1;
    row4 = 0;
    
    if (col1)
        return 7;
    else if (col2)
        return 8;
    else if (col3)
        return 9;  
        
    row1 = 0;
    row2 = 0;
    row3 = 0;
    row4 = 1;
    
    if (col1)
        return 10;
    else if (col2)
        return 0;
    else if (col3)
        return 11;  
                   
    row1 = 0;
    row2 = 0;
    row3 = 0;
    row4 = 0;
    
    return -1;
}

//--------------- Check against code ---------------

bool getCode(){

    char codeTry[] = "";
    int previous = -1;
    int a = -1;
    
    while(strlen(codeTry) < strlen(code)){
    
        int cycles = 0;
    
        while ((a == previous && cycles < 40) || a == -1){ //keep looping until different to last, or held down
            a = keyNum();
            cycles++;
            wait(0.01);
        }
       
        sprintf(codeTry, "%s%d", codeTry, a);
        
        switch(strlen(codeTry)){
            case 1: myled1 = 1; break;
            case 2: myled2 = 1; break;
            case 3: myled3 = 1; break;
            case 4: myled4 = 1;
        }
        
        previous = a;
        wait (0.1);
    }
    
    all(0);
    
    pc.printf("code entered: '%s'\n", codeTry);
    
    if(strcmp(code, codeTry) == 0){
        return true;
    }
    
    return false;
}

//--------------- Check what key is pressed ---------------

void keyCheck(){

    bool j = 0;
    
    while (1){
        int a = keyNum();
        if(a == 11){     //on hash close the app
            myled1 = 0;
            break;
        }
        if(a!=-1){
            pc.printf("%d\n", a); //send key to pc
        }
        
        j = !j;
        myled1 = j;        //flash LED1
        
        wait (0.1);
    }
}

//---------------- Door keypad ---------------

void doorlock(){

    bool password = getCode();

    if (password){
        pc.printf("Password correct\n");
        resetServo();
    } else {
        all(1);
        wait(0.5);
        all(0);
        pc.printf("Password incorrect\n");
    }
}

//-------------------- Main -------------------

int main() {
    
    pc.printf("Program started\n");
    
    accData();
    
    //doorlock();
    //resetServo();
    
    pc.printf("Program complete\n\n");
}
