/* mbed Microcontroller Library - Servo
 * Copyright (c) 2007-2008, sford
 */
 
#ifndef MBED_SERVO_H
#define MBED_SERVO_H

#include "Servo.h"

#include "mbed.h"
#include "platform.h"


namespace mbed {

/* Class: Servo
 *  Abstraction on top of PwmOut to control the position of a servo motor
 *
 * Example:
 * > // Continuously sweep the servo through it's full range
 * >
 * > #include "mbed.h"
 * > #include "Servo.h"
 * >
 * > Servo myServo (p21);
 * > int main() {
 * > int i;
 * > while (1) {
 * >     for (i=0 ; i<100 ; i++){
 * >         myServo = i/100.0;
 * >         wait (0.01);
 * >     }
 * >     for (i=100 ; i>0 ; i--){
 * >         myServo = i/100.0;
 * >         wait (0.01);
 * >     }
 * >  }
 * >}
 */


class Servo : public Base {

public:
    /* Constructor: Servo
     *  Create a servo object connected to the specified PwmOut pin
     *
     * Variables:
     *  pin - PwmOut pin to connect to 
     */
    Servo(PinName pin, const char* = NULL);
	
    /* Function: write
     *  Set the servo position, normalised to it's full range
     *
     * Variables:
     *  percent - A normalised number 0.0-1.0 to represent the full range.
     */
    void write(float percent);
    /* Function: read
     *  Read the servo motors current position
     *
     * Variables:
     *  returns - A normalised number 0.0-1.0  representing the full range.
     */
    float read();
    /* Function: operator=
     *  Shorthand for the write and read functions
     */
    Servo& operator= (float percent);
    Servo& operator= (Servo& rhs);
    operator float();

#ifdef MBED_RPC
    virtual const struct rpc_method *get_rpc_methods();
    static struct rpc_class *get_rpc_class();
#endif

protected:

    PwmOut _pwm;
    float _p;
};

}

#endif
