#include "mbed.h"

Serial pc(USBTX, USBRX);    // debugging

DigitalOut enable(p26);    // enable pin
I2C i2c(p28, p27);         // accelerometer

const int address = 0x30;

const int CTRL_REGB = 0x0D;
const int CTRL_REGC = 0x0C;

const int XOUT_H = 0x00;    //x
const int XOUT_L = 0x01;

const int YOUT_H = 0x02;    //y
const int YOUT_L = 0x03;

const int ZOUT_H = 0x04;    //z
const int ZOUT_L = 0x05;


//--------------- IC2 helper functions ---------------

// write value into register regno, return success
bool write_reg(int regno, int value) {

    char data[2] = {regno, value}; 
    
    return i2c.write(address, data, 2) == 0;
    
}

// read value from register regno, return success
bool read_reg(int regno, int *value) {

    char data = regno; 
    
    if (i2c.write(address, &data, 1) == 0 && i2c.read(address, &data, 1) == 0){
        *value = data;
        return true;
    }
    return false;
    
}

// read complete value of X axis, return it or -1 on failure
int read_x() {

    int low, high;
    
    if ( read_reg(XOUT_H, &high) && read_reg(XOUT_L, &low) )
        return high<<8 | low;
    else
        return -1;
}

// read complete value of Y axis, return it or -1 on failure
int read_y() {

    int low, high;
    
    if ( read_reg(YOUT_H, &high) && read_reg(YOUT_L, &low) )
        return high<<8 | low;
    else
        return -1;
}

// read complete value of Z axis, return it or -1 on failure
int read_z() {

    int low, high;
    
    if ( read_reg(ZOUT_H, &high) && read_reg(ZOUT_L, &low) )
        return high<<8 | low;
    else
        return -1;
}

void accData(){

    enable = 1;
    
    write_reg(CTRL_REGB, 0xC2);
    write_reg(CTRL_REGC, 0x00);
    
    for (int i = 0; i < 1000; i++){
    
        printf("%d,%d,%d \n", read_x(), read_y(), read_z());

        wait(0.05);

    }
    
    enable = 0;

}

void accLEDs(){

    DigitalOut x0(p20);    //red
    DigitalOut x1(p19);    //green
    DigitalOut x2(p16);    //green
    DigitalOut x3(p15);    //green
    DigitalOut x4(p13);    //green
    DigitalOut x5(p11);    //red
    
    enable = 1;
    
    write_reg(CTRL_REGB, 0xC2); //start
    write_reg(CTRL_REGC, 0x00);
    
    for (int i = 0; i < 1000; i++){
    
        double x = double (read_x() - 32768)/9000; //normalise to around 0g/1g
        double y = double (read_y() - 32768)/9000;
        double z = double (read_z() - 32768)/9000;
        
        //pc.printf("%.2f, %.2f, %.2f \n", x, y, z);
        //pc.printf("%.2f \n", x);
        
        x0 = 0; x1 = 0; x2 = 0; x3 = 0; x4 = 0; x5 = 0;
        
        int intx = (x+0.1)*5; //scale to an integer from 0 to 5
        
        pc.printf("%d \n", intx);
        
        switch (intx) {
        
            case 0:
                x0 = 1;
                break;
            case 1:
                x1 = 1;
                break;  
            case 2:
                x2 = 1;
                break;  
            case 3:
                x3 = 1;
                break;  
            case 4:
                x4 = 1;
                break;  
            case 5:
                x5 = 1;
                break;      
                
            default: 
                break;
        }
        
        wait(0.1);
        
    }
    
    x0 = 0; x1 = 0; x2 = 0; x3 = 0; x4 = 0; x5 = 0;
    
    enable = 0;

}


//-------------------- Main -------------------

int main() {
    
    pc.printf("Program started\n");
    
    //accData();
    
    accLEDs();
    
    pc.printf("Program complete\n\n");
}
