#include "mbed.h"
#include "MPU6050.h"
#include "gps_event_vitesse.h"



#define GPSRX p14
#define GPSTX p13
Gps gps(GPSTX,GPSRX);

#define MPU6050_ACCELERO_RANGE_2G   0
MPU6050 mpu(p28, p27);
Ticker timeracc;
int flipacc = 1;

Serial pc(USBTX, USBRX);

void attimeacc()
{
    flipacc = !flipacc;
}

int main ()
{
    pc.baud(9600);
    int accdata[3];
    float x;
    float y;
    float z;
    timeracc.attach(&attimeacc, 0.1);

    //wait(0.1);

    if (mpu.testConnection())
        pc.printf("MPU connection succeeded\n\r");
    else
        pc.printf("MPU connection failed\n\r");


    while(1) {
        if (flipacc==0) {
            mpu.getAcceleroRaw(accdata);
            x= (float)((accdata[0])/16384.0f);
            y= (float)((accdata[1])/16384.0f);
            z= (float)((accdata[2])/16384.0f);
            
            pc.printf("Accelero data: X: %f - Y: %f - Z: %f\n\r", x, y, z);
            flipacc=1;
        }
       if (gps.sample()) {
            pc.printf("Trame $GPGGA recue ");
            
            if (gps.lock()) 
            
            pc.printf("Gps Loocked,%d,%06.0lf,%d,%f,%c,%lf,%c,%.0lf,%.0lf,$\r\n",gps.nbsattelite(),gps.time(),gps.lock(),gps.latitude(),gps.ns(),gps.longitude(),gps.ew(),gps.vitesse_gps());
            else
            pc.printf("Gps UnLoocked,%d,%06.0lf,%d,%lf,%c,%lf,%c,%s,%s,$\r\n",gps.nbsattelite(),gps.time(),gps.lock(),gps.latitude(),gps.ns(),gps.longitude(),gps.ew(),"--");
        }
    }
}
