#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "broker.hivemq.com"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

char* topic;

/**
    TODO
    ----
    
    -   Make an MQTT-service which:
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -   Before implementing MQTT, test the multiclick feature first.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/
InterruptIn button1(USER_BUTTON);
int sendMessage(MQTT::Client<MQTTNetwork, Countdown> client, char* msg, char* topic) {
    MQTT::Message message;
    // QoS 0
    char buf[100];
    sprintf(buf, msg);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    int rc = client.publish(topic, message);
   // while (arrivedcount < 1)
    //    client.yield(100);    
    return rc;
}
int main(int argc, char* argv[])
{
    // enables the interrupt on the button
    button1.fall(callback(button1_onpressed_cb));
    EthernetInterface eth;
    // starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
    if (eth.connect() == 0) {
        printf("Ip address: %s,\n", eth.get_ip_address());
    } else {
        printf("Something went wrong with connecting the ethernet interface\n");
        return -1;
    }
    
    MQTTNetwork mqttNetwork(&eth);
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
    printf("Connecting to %s on port %d", BROKER_NAME, BROKER_PORT);
    // makes a client and connects it to the broker using a client ID and credentials (username & password).
    int rc = mqttNetwork.connect(BROKER_NAME, BROKER_PORT);
    if (rc != 0) {
        printf("return code is %d", rc);
    }
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-sample";
    data.username.cstring = "testusser";
    data.password.cstring = "testpassword";
    int rc2 = client.connect(data);
    if ( rc2 != 0)
        printf("rc from MQTT connect is %d\r\n", rc);
    
    while(1) {
        // Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
        // printf("The button has been pressed %d times \n", multiclick_state);
        
        //makes sure there is no infinite loop in the switch case
        if(multiclick_state != 0) {
            switch(multiclick_state) {
                case 1:
                    printf("Upvote has been sent\n");
                    sendMessage(client, "Upvote", "alex");
                break;
                case 2:
                    printf("Downvote has been sent\n");
                    sendMessage(client, "Downvote", "alex");
                break;
                case 3:
                    printf("No action\n");
                break;
                case 4:
                    printf("Disconnecting...\n");
                    sendMessage(client, "Disconnect", "alex");
                break;
                default:
                    printf("No action\n");
                break;
            }
            multiclick_state = 0;
        }
        
    }
    
    return 0;
}
