#include "debounce_button.h"

/**
    Some tips and tricks:
    -   To use the built-in LED:
            DigitalOut led1(LED1);
            ...
            led1 = 1;
    -   To delay the call of a function:
            Timeout someTimeout;
            ...
            someTimeout.attach(callback(&someFunction), 0.5) with 0.5 as 500 milliseconds
    -   The variables that are used in interrupt callbacks have to be volatile, 
        because these variables can change at any time. Therefore, the compiler is not 
        going to make optimisations.
*/


// init the extern variables
volatile int multiclick_state = 0;
volatile int tempCount = 0;
volatile bool button1_busy = false;
volatile bool button1_pressed = false;
volatile bool button1_enabled = true;
DigitalOut myled(LED1);
Timeout enableButtonTimer;
Timeout resetButtonTimer;

void button1_multiclick_reset_cb(void) {
    //stores the amount of clicks in a variable which is read by the main loop.
    multiclick_state = tempCount;
    //resets the click counter which is used inside this file.
    tempCount = 0;
    //lowers a flag which tells the main loop that the user stopped pressing the button such that it can proceed its program.
    button1_busy = false;
    //turns the built-in LED off. Therefore, the user gets informed that the program stopped counting the clicks.
    myled = 0;
    
}

/**
    TODO
    ----
    This function enables the button again, such that unwanted clicks of the bouncing button get ignored.
*/
void button1_enabled_cb(void)
{
    button1_enabled = true;
}

void button1_onpressed_cb(void)
{
    if(button1_enabled) {
        //disables the button such that the debouncer is active
        button1_enabled = false;
        //enables the button again after a certain amount of time (use interrupts with "button1_enabled_cb()" as callback.)
        enableButtonTimer.attach(callback(&button1_enabled_cb), 0.1);
        //informs the main loop that the button has been pressed
        button1_pressed = true;
        //informs the main loop that the user is clicking the button.
        //Therefore, this main loop cannot continue its procedure until the clicks within 1 second have been counted.
        if(!button1_busy) {
            //turns the built-in LED on, so the user gets informed that the program has started with counting clicks
            myled = 1;
            button1_busy = true;
            resetButtonTimer.attach(callback(&button1_multiclick_reset_cb), 1);
        }
        //counts the amount of clicks within a period of 1 second
        tempCount++;
        
    }
}