#include "mbed.h"

    // Sensors drivers present in the BSP library
#include "stm32l475e_iot01_tsensor.h"
#include "stm32l475e_iot01_hsensor.h"
#include "stm32l475e_iot01_psensor.h"
#include "stm32l475e_iot01_magneto.h"
#include "stm32l475e_iot01_gyro.h"
#include "stm32l475e_iot01_accelero.h"

#define STATE_TEMP 0
#define STATE_HUMIDITY 1
#define STATE_PRESSURE 2
#define STATE_MAGNETO 3
#define STATE_GYRO 4
#define STATE_ACCELERO 5
#define LAST_STATE 5

InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);

static uint8_t state = 0;

void change_state()
{
    if (state == LAST_STATE) {
        state = STATE_TEMP;
    } else {
        state++;
    }
}

int main()
{
    
    button.rise(&change_state);
    
    float sensor_value = 0;
    int16_t pDataXYZ[3] = {0};
    float pGyroDataXYZ[3] = {0};
    
    BSP_TSENSOR_Init();
    BSP_HSENSOR_Init();
    
    BSP_PSENSOR_Init();
    
    BSP_MAGNETO_Init();
    BSP_GYRO_Init();
    BSP_ACCELERO_Init();
    
    while(1) {
        
        led = 1;
        wait(1);
        
        switch (state) {
            case STATE_TEMP:
                sensor_value = BSP_TSENSOR_ReadTemp();
                printf("\nTEMPERATURE = %.2f degC\n", sensor_value);
                break;
            case STATE_HUMIDITY:
                sensor_value = BSP_HSENSOR_ReadHumidity();
                printf("HUMIDITY    = %.2f %%\n", sensor_value);
                break;
            case STATE_PRESSURE:
                sensor_value = BSP_PSENSOR_ReadPressure();
                printf("PRESSURE is = %.2f mBar\n", sensor_value);
                break;
            case STATE_MAGNETO:
                BSP_MAGNETO_GetXYZ(pDataXYZ);
                printf("\nMAGNETO_X = %d\n", pDataXYZ[0]);
                printf("MAGNETO_Y = %d\n", pDataXYZ[1]);
                printf("MAGNETO_Z = %d\n", pDataXYZ[2]);
                break;
            case STATE_GYRO:
                BSP_GYRO_GetXYZ(pGyroDataXYZ);
                printf("\nGYRO_X = %.2f\n", pGyroDataXYZ[0]);
                printf("GYRO_Y = %.2f\n", pGyroDataXYZ[1]);
                printf("GYRO_Z = %.2f\n", pGyroDataXYZ[2]);
                break;
            case STATE_ACCELERO:
                BSP_ACCELERO_AccGetXYZ(pDataXYZ);
                printf("\nACCELERO_X = %d\n", pDataXYZ[0]);
                printf("ACCELERO_Y = %d\n", pDataXYZ[1]);
                printf("ACCELERO_Z = %d\n", pDataXYZ[2]);
                break;
        }
        
        led = 0;
        wait(1);
    }
}
