#include "mbed.h"

Ticker toggle_led_ticker;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

static int value = 0;

#define LEAST_1 1
#define LEAST_2 1 << 1
#define LEAST_3 1 << 2

void toggle_leds() {
    led1 = value & LEAST_1;
    led2 = value & LEAST_2;
    led3 = value & LEAST_3;
}

int main() {
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    
    toggle_led_ticker.attach(&toggle_leds, 0.1);
    while (true) {
        value++;
        if (value == 256) {
            value = 0;
        }
        wait(1);
    }
}