#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Thread thread1;
Thread thread2;

bool is_thread1_done = false;
bool is_thread2_done = true;

void blink(bool * this_is_done, DigitalOut * led) {
    is_thread1_done = false;
    is_thread2_done = false;
    *led = 1;
    wait(1);
    *led = 0;
    *this_is_done = true;
}
                   
void led1_thread(DigitalOut * led) {
    while (true) {
        if(is_thread2_done){
            blink(&is_thread1_done, led);
        }
    }
}

void led2_thread(DigitalOut * led) {
    while (true) {
        if(is_thread1_done){
            blink(&is_thread2_done, led);
        }
    }
}

int main() {
    thread1.start(callback(led1_thread, &led1));
    thread2.start(callback(led2_thread, &led2));
    thread1.join();
    thread2.join();
}
