#include "mbed.h"

#include "stm32l475e_iot01_accelero.h"

#define X_VALUE pDataXYZ[0]
#define Y_VALUE pDataXYZ[1]
#define Z_VALUE pDataXYZ[2]

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int16_t pDataXYZ[3] = {0};

bool is_in_range_100(int val) {
    return val < 100 && val > -100;
}

bool is_in_range_900_1000(int val) {
    return (val < 1050 && val > 950) || (val < -950 && val > -1050);
}

bool board_is_horizontal() {
    return is_in_range_100(X_VALUE) && is_in_range_100(Y_VALUE) && is_in_range_900_1000(Z_VALUE);
}

bool board_is_vertical_short() {
    return is_in_range_900_1000(X_VALUE) && is_in_range_100(Y_VALUE) && is_in_range_100(Z_VALUE);
}

bool board_is_vertical_long() {
    return is_in_range_100(X_VALUE) && is_in_range_900_1000(Y_VALUE) && is_in_range_100(Z_VALUE);
}

void blink_led(DigitalOut * led){
    led1 = 0;
    led2 = 0;
    led3 = 0;
    *led = 1;
    wait(1);
    *led = 0;
}

void blink_all(){
    led1 = 1;
    led2 = 1;
    led3 = 1;
    wait(1);
    led1 = 0;
    led2 = 0;
    led3 = 0;
}

int main(){
    BSP_ACCELERO_Init();
    while(true){
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        bool is_vertical_long = board_is_vertical_long();
        bool is_vertical_short = board_is_vertical_short();
        bool is_horizontal = board_is_horizontal();
        
        if (is_vertical_long && !is_vertical_short && !is_horizontal) {
            blink_led(&led1);
        } else if (!is_vertical_long && is_vertical_short && !is_horizontal) {
            blink_led(&led2);
        } else if (!is_vertical_long && !is_vertical_short && is_horizontal) {
            blink_led(&led3);
        } else {
            blink_all();
        }
        wait(1);
    }
}
